/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.bop.cost.SubqueryCostReport;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.AccessPath;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.model.URI;

public class DataSetSummary {
    public final Set<IV> graphs;
    public final int nknown;
    public final int nunknown;
    public final IV firstContext;

    public static Set<IV> toInternalValues(Set<URI> graphs) {
        LinkedHashSet<IV> s = new LinkedHashSet<IV>();
        for (URI uri : graphs) {
            IV iv = null;
            if (uri != null && uri instanceof BigdataURI) {
                BigdataURI bURI = (BigdataURI)uri;
                iv = bURI.getIV();
            }
            s.add(iv);
        }
        return s;
    }

    public DataSetSummary(Set<IV> graphs, boolean update) {
        IV iv;
        IV firstContext = null;
        if (graphs == null) {
            this.nknown = Integer.MAX_VALUE;
            this.nunknown = Integer.MAX_VALUE;
        } else {
            Iterator<IV> itr = graphs.iterator();
            int nknown = 0;
            int nunknown = 0;
            while (itr.hasNext()) {
                iv = itr.next();
                if (iv == null) continue;
                if (iv.isNullIV()) {
                    ++nunknown;
                    continue;
                }
                if (++nknown != 1) continue;
                firstContext = iv;
            }
            this.nknown = nknown;
            this.nunknown = nunknown;
        }
        this.firstContext = firstContext;
        Object[] a = new IV[this.nknown + (update ? this.nunknown : 0)];
        Iterator<IV> itr = graphs.iterator();
        int nknown = 0;
        while (itr.hasNext()) {
            iv = itr.next();
            if (iv == null || iv.isNullIV() && !update) continue;
            a[nknown++] = iv;
        }
        Arrays.sort(a);
        this.graphs = new LinkedHashSet<IV>(nknown);
        for (int i = 0; i < nknown; ++i) {
            this.graphs.add((IV)a[i]);
        }
    }

    public Set<IV> getGraphs() {
        return this.graphs != null ? this.graphs : Collections.emptySet();
    }

    public SubqueryCostReport estimateSubqueryCost(BOpContextBase context, int limit, Predicate pred) {
        IRelation r = context.getRelation(pred);
        double subqueryCost = 0.0;
        long rangeCount = 0L;
        int nsamples = 0;
        for (IV graph : this.graphs) {
            if (nsamples == limit) break;
            Predicate tmp = pred.asBound((IVariable)pred.get(3), new Constant<IV>(graph));
            AccessPath ap = (AccessPath)context.getAccessPath(r, tmp);
            subqueryCost += ap.estimateCost().cost;
            rangeCount += context.getAccessPath(context.getRelation(tmp), tmp).rangeCount(false);
            ++nsamples;
        }
        subqueryCost = subqueryCost * (double)this.nknown / (double)nsamples;
        rangeCount = rangeCount * (long)this.nknown / (long)nsamples;
        return new SubqueryCostReport(this.nknown, limit, nsamples, rangeCount, subqueryCost);
    }

    public String toString() {
        return "DataSetSummary{ngraphs=" + this.graphs.size() + ", nknown=" + this.nknown + ", nunknown=" + this.nunknown + ", graphs=" + this.graphs + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataSetSummary)) {
            return false;
        }
        DataSetSummary t = (DataSetSummary)o;
        return this.graphs.equals(t.graphs);
    }
}

