/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.ConstructNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupByNode;
import com.bigdata.rdf.sparql.ast.HavingNode;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IGraphPatternContainer;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IProjectionDecl;
import com.bigdata.rdf.sparql.ast.OrderByNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeBase;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SliceNode;
import java.util.Map;
import java.util.Set;

public abstract class QueryBase
extends QueryNodeBase
implements IBindingProducerNode,
IGraphPatternContainer,
IProjectionDecl {
    private static final long serialVersionUID = 1L;

    private QueryBase() {
    }

    public QueryBase(QueryBase queryBase) {
        super(queryBase);
    }

    public QueryBase(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public QueryBase(QueryType queryType) {
        this.setQueryType(queryType);
    }

    public QueryType getQueryType() {
        return (QueryType)((Object)this.getProperty("queryType"));
    }

    public void setQueryType(QueryType queryType) {
        this.setProperty("queryType", (Object)queryType);
    }

    public ConstructNode getConstruct() {
        return (ConstructNode)this.getProperty("construct");
    }

    public void setConstruct(ConstructNode construct) {
        this.setProperty("construct", construct);
        if (construct != null) {
            this.setQueryType(QueryType.CONSTRUCT);
        }
    }

    @Override
    public void setProjection(ProjectionNode projection) {
        this.setProperty("projection", projection);
    }

    @Override
    public ProjectionNode getProjection() {
        return (ProjectionNode)this.getProperty("projection");
    }

    @Override
    public Set<IVariable<?>> getProjectedVars(Set<IVariable<?>> vars) {
        ProjectionNode tmp = this.getProjection();
        if (tmp != null) {
            tmp.getProjectionVars(vars);
        }
        return vars;
    }

    public Set<IVariable<?>> getSelectExprVars(Set<IVariable<?>> vars) {
        ProjectionNode tmp = this.getProjection();
        if (tmp != null) {
            tmp.getSelectExprVars(vars);
        }
        return vars;
    }

    public GraphPatternGroup getWhereClause() {
        return this.getGraphPattern();
    }

    @Override
    public GraphPatternGroup<IGroupMemberNode> getGraphPattern() {
        return (GraphPatternGroup)this.getProperty("graphPattern");
    }

    @Override
    public void setGraphPattern(GraphPatternGroup<IGroupMemberNode> graphPattern) {
        graphPattern.setParent(null);
        super.setProperty("graphPattern", graphPattern);
    }

    public void setWhereClause(GraphPatternGroup whereClause) {
        this.setGraphPattern(whereClause);
    }

    public boolean hasWhereClause() {
        return this.getProperty("graphPattern") != null;
    }

    public GroupByNode getGroupBy() {
        return (GroupByNode)this.getProperty("groupBy");
    }

    public void setGroupBy(GroupByNode groupBy) {
        this.setProperty("groupBy", groupBy);
    }

    public HavingNode getHaving() {
        return (HavingNode)this.getProperty("having");
    }

    public void setHaving(HavingNode having) {
        this.setProperty("having", having);
    }

    public SliceNode getSlice() {
        return (SliceNode)this.getProperty("slice");
    }

    public void setSlice(SliceNode slice) {
        this.setProperty("slice", slice);
    }

    public boolean hasSlice() {
        SliceNode slice = this.getSlice();
        if (slice == null) {
            return false;
        }
        if (slice.getLimit() != Long.MAX_VALUE) {
            return true;
        }
        return slice.getOffset() != 0L;
    }

    public OrderByNode getOrderBy() {
        return (OrderByNode)this.getProperty("orderBy");
    }

    public void setOrderBy(OrderByNode orderBy) {
        this.setProperty("orderBy", orderBy);
    }

    public boolean getIncludeInferred() {
        return this.getProperty("includeInferred", true);
    }

    public void setIncludeInferred(boolean includeInferred) {
        this.setProperty("includeInferred", includeInferred);
    }

    public long getTimeout() {
        return this.getProperty("timeout", Long.MAX_VALUE);
    }

    public void setTimeout(long timeout) {
        this.setProperty("timeout", timeout);
    }

    public void setBindingsClause(BindingsClause bindings) {
        this.setProperty("bindingsClause", bindings);
    }

    public BindingsClause getBindingsClause() {
        return (BindingsClause)this.getProperty("bindingsClause");
    }

    @Override
    public String toString(int indent) {
        String s = QueryBase.indent(indent);
        StringBuilder sb = new StringBuilder();
        ConstructNode construct = this.getConstruct();
        ProjectionNode projection = this.getProjection();
        GraphPatternGroup whereClause = this.getWhereClause();
        GroupByNode groupBy = this.getGroupBy();
        HavingNode having = this.getHaving();
        OrderByNode orderBy = this.getOrderBy();
        SliceNode slice = this.getSlice();
        BindingsClause bindings = this.getBindingsClause();
        if (this.getQueryType() != null) {
            sb.append("\n").append(s).append("QueryType: ").append(this.getQueryType().toString());
        }
        if (this.getProperty("includeInferred") != null) {
            sb.append("\n");
            sb.append(s);
            sb.append("includeInferred=" + this.getIncludeInferred());
        }
        if (this.getProperty("timeout") != null) {
            sb.append("\n");
            sb.append(s);
            sb.append("timeout=" + this.getTimeout());
        }
        if (construct != null && !construct.isEmpty()) {
            sb.append(construct.toString(indent));
        }
        if (projection != null && !projection.isEmpty()) {
            sb.append(projection.toString(indent));
        }
        if (whereClause != null) {
            sb.append(whereClause.toString(indent + 1));
        }
        if (groupBy != null && !groupBy.isEmpty()) {
            sb.append(groupBy.toString(indent));
        }
        if (having != null && !having.isEmpty()) {
            sb.append(having.toString(indent));
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            sb.append(orderBy.toString(indent));
        }
        if (slice != null) {
            sb.append(slice.toString(indent));
        }
        if (this.getQueryHints() != null && !this.getQueryHints().isEmpty()) {
            sb.append("\n");
            sb.append(QueryBase.indent(indent));
            sb.append("queryHints");
            sb.append("=");
            sb.append(this.getQueryHints().toString());
        }
        if (bindings != null) {
            sb.append(bindings.toString(indent + 1));
        }
        return sb.toString();
    }

    public static interface Annotations
    extends QueryNodeBase.Annotations,
    IGraphPatternContainer.Annotations,
    IProjectionDecl.Annotations {
        public static final String QUERY_TYPE = "queryType";
        public static final String CONSTRUCT = "construct";
        public static final String GROUP_BY = "groupBy";
        public static final String HAVING = "having";
        public static final String ORDER_BY = "orderBy";
        public static final String SLICE = "slice";
        public static final String INCLUDE_INFERRED = "includeInferred";
        public static final boolean DEFAULT_INCLUDE_INFERRED = true;
        public static final String TIMEOUT = "timeout";
        public static final long DEFAULT_TIMEOUT = Long.MAX_VALUE;
        public static final String BINDINGS_CLAUSE = "bindingsClause";
    }
}

