/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.NV;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.openrdf.model.URI;

public class FunctionNode
extends ValueExpressionNode {
    private static final long serialVersionUID = 1L;

    public FunctionNode(URI functionURI, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
        super(args, NV.asMap(new NV(Annotations.SCALAR_VALS, scalarValues), new NV(Annotations.FUNCTION_URI, functionURI)));
        if (functionURI == null) {
            throw new IllegalArgumentException();
        }
    }

    public FunctionNode(FunctionNode op) {
        super(op);
    }

    public FunctionNode(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public URI getFunctionURI() {
        return (URI)this.getRequiredProperty(Annotations.FUNCTION_URI);
    }

    public Map<String, Object> getScalarValues() {
        Map scalarValues = (Map)this.getProperty(Annotations.SCALAR_VALS);
        if (scalarValues == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(scalarValues);
    }

    @Override
    public void invalidate() {
        super.clearProperty("valueExpr");
        super.invalidate();
    }

    public boolean isBound() {
        if (FunctionRegistry.BOUND.equals((Object)this.getFunctionURI())) {
            return true;
        }
        int arity = this.arity();
        for (int i = 0; i < arity; ++i) {
            BOp child = this.get(i);
            if (!(child instanceof FunctionNode) || ((FunctionNode)child).isBound()) continue;
            return true;
        }
        return false;
    }

    public static FunctionNode AND(ValueExpressionNode t1, ValueExpressionNode t2) {
        return new FunctionNode(FunctionRegistry.AND, null, t1, t2);
    }

    public static FunctionNode OR(ValueExpressionNode t1, ValueExpressionNode t2) {
        return new FunctionNode(FunctionRegistry.OR, null, t1, t2);
    }

    public static FunctionNode NOT(ValueExpressionNode inner) {
        return new FunctionNode(FunctionRegistry.NOT, null, inner);
    }

    public static FunctionNode add(ValueExpressionNode t1, ValueExpressionNode t2) {
        return new FunctionNode(FunctionRegistry.ADD, null, t1, t2);
    }

    public static FunctionNode subtract(ValueExpressionNode t1, ValueExpressionNode t2) {
        return new FunctionNode(FunctionRegistry.SUBTRACT, null, t1, t2);
    }

    public static FunctionNode sameTerm(ValueExpressionNode t1, ValueExpressionNode t2) {
        return new FunctionNode(FunctionRegistry.SAME_TERM, null, t1, t2);
    }

    public static FunctionNode EQ(ValueExpressionNode t1, ValueExpressionNode t2) {
        return new FunctionNode(FunctionRegistry.EQ, null, t1, t2);
    }

    public static FunctionNode NE(ValueExpressionNode t1, ValueExpressionNode t2) {
        return new FunctionNode(FunctionRegistry.NE, null, t1, t2);
    }

    public static FunctionNode LT(ValueExpressionNode t1, ValueExpressionNode t2) {
        return new FunctionNode(FunctionRegistry.LT, null, t1, t2);
    }

    public static FunctionNode GT(ValueExpressionNode t1, ValueExpressionNode t2) {
        return new FunctionNode(FunctionRegistry.GT, null, t1, t2);
    }

    public static FunctionNode LE(ValueExpressionNode t1, ValueExpressionNode t2) {
        return new FunctionNode(FunctionRegistry.LE, null, t1, t2);
    }

    public static FunctionNode GE(ValueExpressionNode t1, ValueExpressionNode t2) {
        return new FunctionNode(FunctionRegistry.GE, null, t1, t2);
    }

    public static FunctionNode MIN(ValueExpressionNode v1, ValueExpressionNode v2) {
        return new FunctionNode(FunctionRegistry.MIN, null, v1, v2);
    }

    public static FunctionNode MAX(ValueExpressionNode v1, ValueExpressionNode v2) {
        return new FunctionNode(FunctionRegistry.MAX, null, v1, v2);
    }

    public static FunctionNode binary(URI uri, TermNode t1, TermNode t2) {
        return new FunctionNode(uri, null, t1, t2);
    }

    @Override
    public String toString(int i) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        Integer bopId = (Integer)this.getProperty(Annotations.BOP_ID);
        if (bopId != null) {
            sb.append("[" + bopId + "]");
        }
        sb.append("(");
        int nwritten = 0;
        Iterator<BOp> itr = this.argIterator();
        while (itr.hasNext()) {
            BOp t = itr.next();
            if (nwritten > 0) {
                sb.append(',');
            }
            if (t == null) {
                sb.append("<null>");
            } else {
                sb.append(((IValueExpressionNode)t).toString(i + 1));
            }
            ++nwritten;
        }
        sb.append(")");
        this.annotationsToString(sb, i);
        return sb.toString();
    }

    static interface Annotations
    extends ValueExpressionNode.Annotations {
        public static final String FUNCTION_URI = FunctionNode.class.getName() + ".functionURI";
        public static final String SCALAR_VALS = FunctionNode.class.getName() + ".scalarVals";
    }
}

