/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.ModifiableBOpBase;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.GroupMemberValueExpressionNodeBase;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNodeContainer;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AssignmentNode
extends GroupMemberValueExpressionNodeBase
implements IValueExpressionNode,
Comparable<AssignmentNode>,
IBindingProducerNode,
IValueExpressionNodeContainer {
    private static final long serialVersionUID = 1L;

    public AssignmentNode(VarNode var, IValueExpressionNode ve) {
        super(new BOp[]{var, (BOp)ve}, null);
    }

    public AssignmentNode(AssignmentNode op) {
        super(op);
    }

    public AssignmentNode(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (!(args[0] instanceof VarNode)) {
            throw new IllegalArgumentException();
        }
    }

    public VarNode getVarNode() {
        return (VarNode)this.get(0);
    }

    public IVariable<IV> getVar() {
        return this.getVarNode().getValueExpression();
    }

    @Override
    public IValueExpressionNode getValueExpressionNode() {
        return (IValueExpressionNode)this.get(1);
    }

    @Override
    public IValueExpression<? extends IV> getValueExpression() {
        return this.getValueExpressionNode().getValueExpression();
    }

    @Override
    public void setValueExpression(IValueExpression<? extends IV> ve) {
        this.getValueExpressionNode().setValueExpression(ve);
    }

    @Override
    public void invalidate() {
        this.getValueExpressionNode().invalidate();
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder(AssignmentNode.indent(indent));
        VarNode var = this.getVarNode();
        IValueExpressionNode ve = this.getValueExpressionNode();
        if (ve == var) {
            sb.append(ve.toString());
        } else {
            sb.append("( ");
            sb.append(ve.toString());
            sb.append(" AS ");
            sb.append(var.toString());
            sb.append(" )");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(AssignmentNode o) {
        return this.getVar().getName().compareTo(o.getVar().getName());
    }

    @Override
    public int replaceAllWith(BOp oldVal, BOp newVal) {
        if (oldVal.equals(this.get(0)) && !(newVal instanceof VarNode)) {
            return 0;
        }
        return super.replaceAllWith(oldVal, newVal);
    }

    @Override
    public ModifiableBOpBase setArgs(BOp[] args) {
        assert (args[0] instanceof VarNode);
        return super.setArgs(args);
    }

    @Override
    public ModifiableBOpBase setArg(int index, BOp newArg) {
        assert (index != 0 || newArg instanceof VarNode);
        return super.setArg(index, newArg);
    }

    @Override
    public Set<IVariable<?>> getRequiredBound(StaticAnalysis sa) {
        IValueExpressionNode vexp = this.getValueExpressionNode();
        Set<IVariable<?>> requiredBound = new HashSet();
        if (vexp != null && vexp instanceof ValueExpressionNode) {
            requiredBound = sa.getSpannedVariables((ValueExpressionNode)vexp, true, requiredBound);
        }
        return requiredBound;
    }

    @Override
    public Set<IVariable<?>> getDesiredBound(StaticAnalysis sa) {
        return new HashSet();
    }
}

