/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.lbs;

import com.bigdata.counters.AbstractStatisticsCollector;
import java.util.Comparator;

public class HostScore {
    private final String hostname;
    private final boolean thisHost;
    private final double availability;
    public static final Comparator<HostScore> COMPARE_BY_SCORE = new Comparator<HostScore>(){

        @Override
        public int compare(HostScore t1, HostScore t2) {
            if (t1.availability < t2.availability) {
                return 1;
            }
            if (t1.availability > t2.availability) {
                return -1;
            }
            return t1.hostname.compareTo(t2.hostname);
        }
    };
    public static final Comparator<HostScore> COMPARE_BY_HOSTNAME = new Comparator<HostScore>(){

        @Override
        public int compare(HostScore t1, HostScore t2) {
            return t1.hostname.compareTo(t2.hostname);
        }
    };

    public double getAvailability() {
        return this.availability;
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean isThisHost() {
        return this.thisHost;
    }

    public String toString() {
        return "HostScore{hostname=" + this.hostname + ", thisHost=" + this.thisHost + ", availabilty=" + this.availability + "}";
    }

    public HostScore(String hostname, double availability) {
        if (hostname == null) {
            throw new IllegalArgumentException();
        }
        if (hostname.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if (availability < 0.0 || availability > 1.0) {
            throw new IllegalArgumentException();
        }
        this.hostname = hostname;
        this.availability = availability;
        this.thisHost = AbstractStatisticsCollector.fullyQualifiedHostName.equals(hostname);
    }
}

