/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.BlueprintsServletProxy;
import com.bigdata.rdf.sail.webapp.ConfigParams;
import com.bigdata.rdf.sail.webapp.DeleteServlet;
import com.bigdata.rdf.sail.webapp.DescribeCacheServlet;
import com.bigdata.rdf.sail.webapp.InsertServlet;
import com.bigdata.rdf.sail.webapp.MapgraphServletProxy;
import com.bigdata.rdf.sail.webapp.QueryServlet;
import com.bigdata.rdf.sail.webapp.StatusServlet;
import com.bigdata.rdf.sail.webapp.UpdateServlet;
import com.bigdata.rdf.sail.webapp.WorkbenchServlet;
import com.bigdata.rdf.sail.webapp.client.MiniMime;
import com.bigdata.util.NV;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openrdf.model.impl.URIImpl;

public class RESTServlet
extends BigdataRDFServlet {
    private static final transient Logger log = Logger.getLogger(RESTServlet.class);
    private static final long serialVersionUID = 1L;
    private QueryServlet m_queryServlet;
    private InsertServlet m_insertServlet;
    private DeleteServlet m_deleteServlet;
    private UpdateServlet m_updateServlet;
    private WorkbenchServlet m_workbenchServlet;
    private BlueprintsServletProxy m_blueprintsServlet;
    private MapgraphServletProxy m_mapgraphServlet;
    private DescribeCacheServlet m_describeServlet;

    public void init() throws ServletException {
        super.init();
        this.m_queryServlet = new QueryServlet();
        this.m_insertServlet = new InsertServlet();
        this.m_updateServlet = new UpdateServlet();
        this.m_deleteServlet = new DeleteServlet();
        this.m_describeServlet = new DescribeCacheServlet();
        this.m_workbenchServlet = new WorkbenchServlet();
        String provider = this.getInitParameter("blueprintsServletProvider");
        String blueprintsProvider = provider == null || provider.equals("") ? ConfigParams.DEFAULT_BLUEPRINTS_SERVLET_PROVIDER : provider;
        this.m_blueprintsServlet = BlueprintsServletProxy.BlueprintsServletFactory.getInstance(blueprintsProvider);
        provider = this.getInitParameter("mapgraphServletProvider");
        String mapgraphProvider = provider == null || provider.equals("") ? ConfigParams.DEFAULT_MAPGRAPH_SERVLET_PROVIDER : provider;
        this.m_mapgraphServlet = new MapgraphServletProxy.MapgraphServletFactory().getInstance(mapgraphProvider);
        this.m_queryServlet.init(this.getServletConfig());
        this.m_insertServlet.init(this.getServletConfig());
        this.m_updateServlet.init(this.getServletConfig());
        this.m_deleteServlet.init(this.getServletConfig());
        this.m_describeServlet.init(this.getServletConfig());
        this.m_workbenchServlet.init(this.getServletConfig());
        this.m_blueprintsServlet.init(this.getServletConfig());
        this.m_mapgraphServlet.init(this.getServletConfig());
    }

    public void destroy() {
        if (this.m_queryServlet != null) {
            this.m_queryServlet.destroy();
            this.m_queryServlet = null;
        }
        if (this.m_insertServlet != null) {
            this.m_insertServlet.destroy();
            this.m_insertServlet = null;
        }
        if (this.m_updateServlet != null) {
            this.m_updateServlet.destroy();
            this.m_updateServlet = null;
        }
        if (this.m_deleteServlet != null) {
            this.m_deleteServlet.destroy();
            this.m_deleteServlet = null;
        }
        if (this.m_describeServlet != null) {
            this.m_describeServlet.destroy();
            this.m_describeServlet = null;
        }
        if (this.m_workbenchServlet != null) {
            this.m_workbenchServlet.destroy();
            this.m_workbenchServlet = null;
        }
        if (this.m_blueprintsServlet != null) {
            this.m_blueprintsServlet.destroy();
            this.m_blueprintsServlet = null;
        }
        if (this.m_mapgraphServlet != null) {
            this.m_mapgraphServlet.destroy();
            this.m_mapgraphServlet = null;
        }
        super.destroy();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pathInfo;
        if (log.isInfoEnabled()) {
            log.info((Object)req.toString());
        }
        if ((pathInfo = req.getPathInfo()) != null && !pathInfo.endsWith("/sparql")) {
            URIImpl uri = new URIImpl(req.getRequestURL().toString());
            if (this.m_describeServlet != null) {
                req.setAttribute("describeUris", Collections.singleton(uri));
                this.m_describeServlet.doGet(req, resp);
                if (resp.isCommitted()) {
                    return;
                }
            }
            req.setAttribute("query", (Object)("DESCRIBE <" + uri.stringValue() + ">"));
            this.m_queryServlet.doSparqlQuery(req, resp);
            return;
        }
        this.m_queryServlet.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)req.toString());
        }
        if (req.getParameter("query") != null || req.getParameter("update") != null || req.getParameter("uuid") != null || req.getParameter("ESTCARD") != null || req.getParameter("HASSTMT") != null || req.getParameter("GETSTMTS") != null || req.getParameter("CONTEXTS") != null || RESTServlet.hasMimeType(req, "application/sparql-update") || RESTServlet.hasMimeType(req, "application/sparql-query")) {
            this.m_queryServlet.doPost(req, resp);
        } else if (req.getParameter("updatePost") != null) {
            this.m_updateServlet.doPost(req, resp);
        } else if (req.getParameter("delete") != null) {
            this.m_deleteServlet.doPost(req, resp);
        } else if (req.getParameter("cancelQuery") != null) {
            StatusServlet.doCancelQuery(req, resp, this.getIndexManager(), this.getBigdataRDFContext());
            RESTServlet.buildAndCommitResponse(resp, 200, "text/plain", "", new NV[0]);
        } else if (req.getParameter("workbench") != null) {
            this.m_workbenchServlet.doPost(req, resp);
        } else if (req.getParameter("blueprints") != null) {
            this.m_blueprintsServlet.doPostRequest(req, resp);
        } else if (req.getParameter("mapgraph") != null) {
            this.m_mapgraphServlet.doPostRequest(req, resp);
        } else if (req.getParameter("uri") != null) {
            this.m_insertServlet.doPost(req, resp);
        } else {
            this.m_insertServlet.doPost(req, resp);
        }
    }

    static boolean hasMimeType(HttpServletRequest req, String mimeType) {
        String contentType = req.getContentType();
        return contentType != null && mimeType.equals(new MiniMime(contentType).getMimeType());
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)req.toString());
        }
        this.m_updateServlet.doPut(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)req.toString());
        }
        this.m_deleteServlet.doDelete(req, resp);
    }
}

