/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.BigdataStatics;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.counters.CAT;
import com.bigdata.io.NullOutputStream;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.ITransactionService;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.changesets.IChangeRecord;
import com.bigdata.rdf.sail.BigdataBaseContext;
import com.bigdata.rdf.sail.BigdataSailBooleanQuery;
import com.bigdata.rdf.sail.BigdataSailGraphQuery;
import com.bigdata.rdf.sail.BigdataSailQuery;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.BigdataSailTupleQuery;
import com.bigdata.rdf.sail.BigdataSailUpdate;
import com.bigdata.rdf.sail.ISPARQLUpdateListener;
import com.bigdata.rdf.sail.SPARQLUpdateEvent;
import com.bigdata.rdf.sail.webapp.AbstractRestApiTask;
import com.bigdata.rdf.sail.webapp.ConnegUtil;
import com.bigdata.rdf.sail.webapp.HTMLBuilder;
import com.bigdata.rdf.sail.webapp.SparqlEndpointConfig;
import com.bigdata.rdf.sail.webapp.XMLBuilder;
import com.bigdata.rdf.sail.webapp.client.StringUtil;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.QueryHints;
import com.bigdata.rdf.sparql.ast.QueryOptimizerEnum;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.Update;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.sparse.SparseRowStore;
import com.bigdata.util.DaemonThreadFactory;
import com.bigdata.util.concurrent.ThreadPoolExecutorBaseStatisticsTask;
import info.aduna.xml.XMLWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.AbstractOperation;
import org.openrdf.query.impl.AbstractQuery;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.BooleanQueryResultWriter;
import org.openrdf.query.resultio.BooleanQueryResultWriterFactory;
import org.openrdf.query.resultio.BooleanQueryResultWriterRegistry;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;
import org.openrdf.query.resultio.TupleQueryResultWriterFactory;
import org.openrdf.query.resultio.TupleQueryResultWriterRegistry;
import org.openrdf.query.resultio.sparqlxml.SPARQLResultsXMLWriter;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;

public class BigdataRDFContext
extends BigdataBaseContext {
    private static final transient Logger log = Logger.getLogger(BigdataRDFContext.class);
    protected static final String EXPLAIN = "explain";
    protected static final String EXPLAIN_DETAILS = "details";
    protected static final String ANALYTIC = "analytic";
    protected static final String RTO = "RTO";
    protected static final String XHTML = "xhtml";
    protected static final String XSL_STYLESHEET = "xsl-stylesheet";
    protected static final String DEFAULT_XSL_STYLESHEET = BigdataStatics.getContextPath() + "/html/result-to-html.xsl";
    protected static final String MONITOR = "monitor";
    protected static final String DEFAULT_GRAPH_URI = "default-graph-uri";
    protected static final String NAMED_GRAPH_URI = "named-graph-uri";
    protected static final String USING_GRAPH_URI = "using-graph-uri";
    protected static final String URI = "uri";
    protected static final String CONTEXT_URI = "context-uri";
    protected static final String USING_NAMED_GRAPH_URI = "using-named-graph-uri";
    protected static final String NAMESPACE = "namespace";
    public static final String HTTP_HEADER_BIGDATA_MAX_QUERY_MILLIS = "X-BIGDATA-MAX-QUERY-MILLIS";
    public static final String HTTP_HEADER_ECHO_BACK_QUERY = "X-ECHO-BACK-QUERY";
    static final String MAX_QUERY_TIME_MILLIS = "maxQueryTimeMillis";
    static final String TIMEOUT = "timeout";
    static final String BASE_URI = "baseURI";
    private final SparqlEndpointConfig m_config;
    final ExecutorService queryService;
    private final ScheduledFuture<?> m_queueStatsFuture;
    private final ThreadPoolExecutorBaseStatisticsTask m_queueSampleTask;
    private final ConcurrentHashMap<Long, RunningQuery> m_queries = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, RunningQuery> m_queries2 = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, TaskAndFutureTask<?>> m_restTasks = new ConcurrentHashMap();
    private final AtomicLong m_queryIdFactory = new AtomicLong();

    RunningQuery getQueryById(UUID queryId2) {
        return this.m_queries2.get(queryId2);
    }

    final Map<Long, RunningQuery> getQueries() {
        return this.m_queries;
    }

    public final AtomicLong getQueryIdFactory() {
        return this.m_queryIdFactory;
    }

    TaskAndFutureTask<?> getTaskById(UUID uuid) {
        return this.m_restTasks.get(uuid);
    }

    <T> void addTask(AbstractRestApiTask<T> task, FutureTask<T> ft) {
        this.m_restTasks.put(task.uuid, new TaskAndFutureTask<T>(task, ft, System.nanoTime()));
    }

    void removeTask(UUID uuid) {
        TaskAndFutureTask<?> task = this.m_restTasks.remove(uuid);
        if (task != null) {
            task.done();
        }
    }

    final Map<UUID, TaskAndFutureTask<?>> getTasks() {
        return this.m_restTasks;
    }

    public BigdataRDFContext(SparqlEndpointConfig config, IIndexManager indexManager) {
        super(indexManager);
        if (config == null) {
            throw new IllegalArgumentException();
        }
        if (config.namespace == null) {
            throw new IllegalArgumentException();
        }
        this.m_config = config;
        this.queryService = config.queryThreadPoolSize == 0 ? (ThreadPoolExecutor)Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory(this.getClass().getName() + ".queryService")) : (ThreadPoolExecutor)Executors.newFixedThreadPool(config.queryThreadPoolSize, (ThreadFactory)new DaemonThreadFactory(this.getClass().getName() + ".queryService"));
        if (indexManager.getCollectQueueStatistics()) {
            long initialDelay = 0L;
            long delay = 1000L;
            TimeUnit unit = TimeUnit.MILLISECONDS;
            this.m_queueSampleTask = new ThreadPoolExecutorBaseStatisticsTask((ThreadPoolExecutor)this.queryService);
            this.m_queueStatsFuture = indexManager.addScheduledTask(this.m_queueSampleTask, 0L, 1000L, unit);
        } else {
            this.m_queueSampleTask = null;
            this.m_queueStatsFuture = null;
        }
    }

    void shutdownNow() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Immediate shutdown.");
        }
        if (this.m_queueStatsFuture != null) {
            this.m_queueStatsFuture.cancel(true);
        }
        this.queryService.shutdownNow();
    }

    public SparqlEndpointConfig getConfig() {
        return this.m_config;
    }

    public ThreadPoolExecutorBaseStatisticsTask getSampleTask() {
        return this.m_queueSampleTask;
    }

    public static String getBaseURI(HttpServletRequest req, HttpServletResponse resp) {
        String baseURI = req.getParameter(BASE_URI);
        if (baseURI == null) {
            baseURI = req.getRequestURL().toString();
        }
        return baseURI;
    }

    protected static Boolean getEffectiveBooleanValue(String s, Boolean defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        if ((s = s.trim()).length() == 0) {
            return true;
        }
        return Boolean.valueOf(s);
    }

    protected static String getEffectiveStringValue(String s, String defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        if ((s = s.trim()).length() == 0) {
            return defaultValue;
        }
        return s;
    }

    private static boolean isExplainDetails(HttpServletRequest req) {
        String[] vals = req.getParameterValues(EXPLAIN);
        if (vals == null) {
            return false;
        }
        for (String val : vals) {
            if (!val.equals(EXPLAIN_DETAILS)) continue;
            return true;
        }
        return false;
    }

    UpdateTask getUpdateTask(BigdataSailRepositoryConnection cxn, String namespace, long timestamp, String baseURI, Map<String, Value> bindings, ASTContainer astContainer, HttpServletRequest req, HttpServletResponse resp, OutputStream os) {
        return new UpdateTask(cxn, namespace, timestamp, baseURI, bindings, astContainer, req, resp, os);
    }

    public AbstractQueryTask getQueryTask(BigdataSailRepositoryConnection cxn, String namespace, long timestamp, String queryStr, String baseURI, ASTContainer astContainer, boolean includeInferred, Map<String, Value> bindings, String acceptOverride, HttpServletRequest req, HttpServletResponse resp, OutputStream os) throws MalformedQueryException, IOException {
        String acceptStr;
        boolean xhtml;
        QueryType queryType;
        block19: {
            block21: {
                block20: {
                    block18: {
                        if (cxn == null) {
                            throw new IllegalArgumentException();
                        }
                        if (namespace == null) {
                            throw new IllegalArgumentException();
                        }
                        if (queryStr == null) {
                            throw new IllegalArgumentException();
                        }
                        if (baseURI == null) {
                            throw new IllegalArgumentException();
                        }
                        if (astContainer == null) {
                            throw new IllegalArgumentException();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)astContainer.toString());
                        }
                        queryType = astContainer.getOriginalAST().getQueryType();
                        boolean explain = req.getParameter(EXPLAIN) != null;
                        boolean bl = xhtml = req.getParameter(XHTML) != null;
                        if (!explain) break block18;
                        acceptStr = "text/html";
                        break block19;
                    }
                    if (acceptOverride == null) break block20;
                    acceptStr = acceptOverride;
                    break block19;
                }
                if (!xhtml) break block21;
                switch (queryType) {
                    case ASK: {
                        acceptStr = BooleanQueryResultFormat.TEXT.getDefaultMIMEType();
                        break block19;
                    }
                    case SELECT: {
                        acceptStr = TupleQueryResultFormat.SPARQL.getDefaultMIMEType();
                        break block19;
                    }
                    case DESCRIBE: 
                    case CONSTRUCT: {
                        acceptStr = RDFFormat.RDFXML.getDefaultMIMEType();
                        break block19;
                    }
                    default: {
                        throw new AssertionError((Object)("QueryType=" + (Object)((Object)queryType)));
                    }
                }
            }
            ArrayList<String> acceptHeaders = Collections.list(req.getHeaders("Accept"));
            acceptStr = ConnegUtil.getMimeTypeForQueryParameterQueryRequest(req.getParameter("format"), acceptHeaders.toArray(new String[acceptHeaders.size()]));
        }
        ConnegUtil util = new ConnegUtil(acceptStr);
        switch (queryType) {
            case ASK: {
                BooleanQueryResultFormat format = util.getBooleanQueryResultFormat(BooleanQueryResultFormat.SPARQL);
                return new AskQueryTask(cxn, namespace, timestamp, baseURI, includeInferred, bindings, astContainer, queryType, format, req, resp, os);
            }
            case DESCRIBE: 
            case CONSTRUCT: {
                RDFFormat format = util.getRDFFormat(RDFFormat.RDFXML);
                return new GraphQueryTask(cxn, namespace, timestamp, baseURI, includeInferred, bindings, astContainer, queryType, format, req, resp, os);
            }
            case SELECT: {
                String fileExt;
                Charset charset;
                String mimeType;
                TupleQueryResultFormat format = util.getTupleQueryResultFormat(TupleQueryResultFormat.SPARQL);
                if (xhtml) {
                    mimeType = "application/xml";
                    charset = Charset.forName("UTF-8");
                    fileExt = "xml";
                } else {
                    mimeType = format.getDefaultMIMEType();
                    charset = format.getCharset();
                    fileExt = format.getDefaultFileExtension();
                }
                return new TupleQueryTask(cxn, namespace, timestamp, baseURI, includeInferred, bindings, astContainer, queryType, mimeType, charset, fileExt, req, resp, os);
            }
        }
        throw new RuntimeException("Unknown query type: " + (Object)((Object)queryType));
    }

    public AbstractTripleStore getTripleStore(String namespace, long timestamp) {
        AbstractTripleStore tripleStore = (AbstractTripleStore)this.getIndexManager().getResourceLocator().locate(namespace, timestamp);
        return tripleStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getNamespaces(long timestamp) {
        long tx = this.newTx(timestamp);
        try {
            List<String> list = this.getNamespacesTx(tx);
            return list;
        }
        finally {
            this.abortTx(tx);
        }
    }

    public List<String> getNamespacesTx(long tx) {
        SparseRowStore grs;
        if (tx == -1L && this.getIndexManager() instanceof IBigdataFederation) {
            tx = this.getIndexManager().getLastCommitTime();
        }
        if ((grs = this.getIndexManager().getGlobalRowStore(tx)) == null) {
            log.warn((Object)("No GRS @ tx=" + TimestampUtility.toString(tx)));
            return Collections.emptyList();
        }
        return grs.getNamespaces(tx);
    }

    public long newTx(long timestamp) {
        long tx = timestamp;
        if (this.getIndexManager() instanceof IJournal) {
            ITransactionService txs = ((IJournal)this.getIndexManager()).getLocalTransactionManager().getTransactionService();
            try {
                tx = txs.newTx(timestamp);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return tx;
    }

    public void abortTx(long tx) {
        if (this.getIndexManager() instanceof IJournal) {
            ITransactionService txs = ((IJournal)this.getIndexManager()).getLocalTransactionManager().getTransactionService();
            try {
                txs.abort(tx);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void commitTx(long tx) {
        if (this.getIndexManager() instanceof IJournal) {
            ITransactionService txs = ((IJournal)this.getIndexManager()).getLocalTransactionManager().getTransactionService();
            try {
                txs.commit(tx);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void addHtmlHeader(XMLBuilder.Node current, String charset) throws IOException {
        current = current.node("head");
        current.node("meta").attr("http-equiv", "Content-Type").attr("content", "text/html;charset=" + charset).close();
        current.node("title").textNoEncode("blazegraph&trade; by SYSTAP").close();
        current = current.close();
        current = current.node("body");
    }

    static long getQueryTimeout(HttpServletRequest req, long queryTimeoutMillis) {
        long tmp;
        String s = req.getHeader(HTTP_HEADER_BIGDATA_MAX_QUERY_MILLIS);
        if (s != null && (tmp = StringUtil.toLong((String)s)) > 0L && (queryTimeoutMillis == 0L || tmp < queryTimeoutMillis)) {
            queryTimeoutMillis = tmp;
        }
        if ((s = req.getParameter(MAX_QUERY_TIME_MILLIS)) != null && (tmp = StringUtil.toLong((String)s)) > 0L && (queryTimeoutMillis == 0L || tmp < queryTimeoutMillis)) {
            queryTimeoutMillis = tmp;
        }
        if ((s = req.getParameter(TIMEOUT)) != null && (tmp = StringUtil.toLong((String)s) * 1000L) > 0L && (queryTimeoutMillis == 0L || tmp < queryTimeoutMillis)) {
            queryTimeoutMillis = tmp;
        }
        return queryTimeoutMillis;
    }

    static class RunningQuery {
        final long queryId;
        final UUID queryId2;
        final AbstractQueryTask queryTask;
        final long begin;

        public RunningQuery(long queryId, UUID queryId2, long begin, AbstractQueryTask queryTask) {
            if (queryId2 == null) {
                throw new IllegalArgumentException();
            }
            if (queryTask == null) {
                throw new IllegalArgumentException();
            }
            this.queryId = queryId;
            this.queryId2 = queryId2;
            this.begin = begin;
            this.queryTask = queryTask;
        }

        public com.bigdata.rdf.sail.model.RunningQuery getModelRunningQuery() {
            boolean isUpdateQuery = this.queryTask instanceof UpdateTask;
            com.bigdata.rdf.sail.model.RunningQuery modelQuery = new com.bigdata.rdf.sail.model.RunningQuery(Long.toString(this.queryId), this.queryId2, this.begin, isUpdateQuery);
            return modelQuery;
        }
    }

    private static class SparqlUpdateResponseWriter
    implements ISPARQLUpdateListener {
        private final long begin;
        private final HttpServletResponse resp;
        private final OutputStream os;
        private final Writer w;
        private final HTMLBuilder doc;
        private final Charset charset;
        private final XMLBuilder.Node body;
        private final boolean reportLoadProgress;
        private final boolean flushEachEvent;
        private final CAT mutationCount;
        private final boolean echoBack;
        private volatile Update lastOp = null;

        public SparqlUpdateResponseWriter(HttpServletResponse resp, OutputStream os, Charset charset, boolean reportLoadProgress, boolean flushEachEvent, CAT mutationCount, boolean echoBack) throws IOException {
            if (resp == null) {
                throw new IllegalArgumentException();
            }
            if (os == null) {
                throw new IllegalArgumentException();
            }
            this.resp = resp;
            this.os = os;
            this.charset = charset;
            this.w = new OutputStreamWriter(os, charset);
            this.doc = new HTMLBuilder(charset.name(), this.w);
            this.reportLoadProgress = reportLoadProgress;
            this.flushEachEvent = flushEachEvent;
            this.mutationCount = mutationCount;
            this.begin = System.nanoTime();
            this.body = this.writeSparqlUpdateResponseHeader();
            this.echoBack = echoBack;
        }

        private XMLBuilder.Node writeSparqlUpdateResponseHeader() throws IOException {
            XMLBuilder.Node current = this.doc.root("html");
            BigdataRDFContext.addHtmlHeader(current, this.charset.name());
            return current;
        }

        @Override
        public void updateEvent(SPARQLUpdateEvent e) {
            try {
                long totalElapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.begin);
                long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(e.getElapsedNanos());
                if (e instanceof SPARQLUpdateEvent.LoadProgress) {
                    if (this.reportLoadProgress) {
                        SPARQLUpdateEvent.LoadProgress tmp = (SPARQLUpdateEvent.LoadProgress)e;
                        long parsed = tmp.getParsedCount();
                        Update thisOp = e.getUpdate();
                        if (thisOp != this.lastOp) {
                            this.lastOp = thisOp;
                            this.body.node("pre").text(thisOp.toString()).close();
                        }
                        this.body.node("br").text("totalElapsed=" + totalElapsedMillis + "ms, elapsed=" + elapsedMillis + "ms, parsed=" + parsed + ", tps=" + tmp.triplesPerSecond() + ", done=" + tmp.isDone()).close();
                    }
                } else if (e.getCause() != null) {
                    Throwable t = e.getCause();
                    StringWriter w = new StringWriter();
                    PrintWriter pw = new PrintWriter(w);
                    t.printStackTrace(pw);
                    pw.flush();
                    pw.close();
                    this.body.node("p").text("ABORT").close().node("pre").text(e.getUpdate().toString()).close().node("pre").text(w.toString()).close().node("p").text("totalElapsed=" + totalElapsedMillis + "ms, elapsed=" + elapsedMillis + "ms").close();
                    this.body.node("hr").close();
                } else {
                    if (this.lastOp == e.getUpdate()) {
                        this.lastOp = null;
                    } else {
                        SPARQLUpdateEvent.DeleteInsertWhereStats deleteInsertWhereStats = e.getDeleteInsertWhereStats();
                        if (this.echoBack) {
                            this.body.node("pre").text(e.getUpdate().toString()).close();
                        }
                        this.body.node("p").text("totalElapsed=" + totalElapsedMillis + "ms, elapsed=" + elapsedMillis + "ms, connFlush=" + TimeUnit.NANOSECONDS.toMillis(e.getConnectionFlushNanos()) + "ms, batchResolve=" + TimeUnit.NANOSECONDS.toMillis(e.getBatchResolveNanos()) + (deleteInsertWhereStats == null ? "" : ", whereClause=" + TimeUnit.NANOSECONDS.toMillis(deleteInsertWhereStats.whereNanos.get()) + "ms, deleteClause=" + TimeUnit.NANOSECONDS.toMillis(deleteInsertWhereStats.deleteNanos.get()) + "ms, insertClause=" + TimeUnit.NANOSECONDS.toMillis(deleteInsertWhereStats.whereNanos.get()) + "ms")).close();
                    }
                    this.body.node("hr").close();
                }
                if (this.flushEachEvent) {
                    this.w.flush();
                    this.os.flush();
                    this.resp.flushBuffer();
                }
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }

        public void commit(long commitTime) throws IOException {
            long totalElapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.begin);
            this.body.node("p").text("COMMIT: totalElapsed=" + totalElapsedMillis + "ms, commitTime=" + commitTime + ", mutationCount=" + this.mutationCount.get()).close();
        }

        public void flush() throws IOException {
            this.doc.closeAll(this.body);
            this.w.flush();
            this.w.close();
        }
    }

    class UpdateTask
    extends AbstractQueryTask {
        public final AtomicLong commitTime;
        private boolean echoBack;
        private final CAT mutationCount;

        public UpdateTask(BigdataSailRepositoryConnection cxn, String namespace, long timestamp, String baseURI, Map<String, Value> bindings, ASTContainer astContainer, HttpServletRequest req, HttpServletResponse resp, OutputStream os) {
            super(cxn, namespace, timestamp, baseURI, true, bindings, astContainer, req, resp, os);
            this.commitTime = new AtomicLong(-1L);
            this.echoBack = false;
            this.mutationCount = new CAT();
            cxn.addChangeLog(new IChangeLog(){

                @Override
                public void changeEvent(IChangeRecord record) {
                    UpdateTask.this.mutationCount.increment();
                }

                @Override
                public void transactionBegin() {
                }

                @Override
                public void transactionPrepare() {
                }

                @Override
                public void transactionCommited(long commitTime) {
                }

                @Override
                public void transactionAborted() {
                }

                @Override
                public void close() {
                }
            });
        }

        @Override
        protected void doQuery(BigdataSailRepositoryConnection cxn, OutputStream os) throws Exception {
            SparqlUpdateResponseWriter listener;
            ByteArrayOutputStream baos;
            BigdataSailUpdate update = this.setupUpdate(cxn);
            if (this.req.getHeader(BigdataRDFContext.HTTP_HEADER_ECHO_BACK_QUERY) != null) {
                this.echoBack = Boolean.parseBoolean(this.req.getHeader(BigdataRDFContext.HTTP_HEADER_ECHO_BACK_QUERY));
            }
            if (this.monitor) {
                baos = null;
                this.resp.setStatus(200);
                this.resp.setContentType("text/html; charset=" + this.charset.name());
                boolean flushEachEvent = false;
                listener = new SparqlUpdateResponseWriter(this.resp, os, this.charset, true, false, this.mutationCount, this.echoBack);
            } else {
                baos = new ByteArrayOutputStream();
                listener = new SparqlUpdateResponseWriter(this.resp, baos, this.charset, false, false, this.mutationCount, this.echoBack);
            }
            cxn.getSailConnection().addListener(listener);
            this.commitTime.set(update.execute2());
            listener.commit(this.commitTime.get());
            listener.flush();
            if (baos != null) {
                this.resp.setStatus(200);
                this.resp.setContentType("text/html; charset=" + this.charset.name());
                baos.flush();
                os.write(baos.toByteArray());
            }
        }

        public long getMutationCount() {
            return this.mutationCount.get();
        }
    }

    private class GraphQueryTask
    extends AbstractQueryTask {
        public GraphQueryTask(BigdataSailRepositoryConnection cxn, String namespace, long timestamp, String baseURI, boolean includeInferred, Map<String, Value> bindings, ASTContainer astContainer, QueryType queryType, RDFFormat format, HttpServletRequest req, HttpServletResponse resp, OutputStream os) {
            super(cxn, namespace, timestamp, baseURI, includeInferred, bindings, astContainer, queryType, format.getDefaultMIMEType(), format.getCharset(), format.getDefaultFileExtension(), req, resp, os);
        }

        @Override
        protected void doQuery(BigdataSailRepositoryConnection cxn, OutputStream os) throws Exception {
            BigdataSailGraphQuery query = (BigdataSailGraphQuery)this.setupQuery(cxn);
            RDFFormat format = (RDFFormat)RDFWriterRegistry.getInstance().getFileFormatForMIMEType(this.mimeType);
            RDFWriter w = ((RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format)).getWriter(os);
            query.evaluate((RDFHandler)w);
        }
    }

    private static class MyXMLWriter
    extends XMLWriter {
        private final String stylesheet;

        public MyXMLWriter(OutputStream outputStream, String stylesheet) {
            super(outputStream);
            this.stylesheet = stylesheet;
        }

        public void startDocument() throws IOException {
            super.startDocument();
            this._writeLn("<?xml-stylesheet type=\"text/xsl\" href=\"" + this.stylesheet + "\" ?>");
        }
    }

    private class TupleQueryTask
    extends AbstractQueryTask {
        public TupleQueryTask(BigdataSailRepositoryConnection cxn, String namespace, long timestamp, String baseURI, boolean includeInferred, Map<String, Value> bindings, ASTContainer astContainer, QueryType queryType, String mimeType, Charset charset, String fileExt, HttpServletRequest req, HttpServletResponse resp, OutputStream os) {
            super(cxn, namespace, timestamp, baseURI, includeInferred, bindings, astContainer, queryType, mimeType, charset, fileExt, req, resp, os);
        }

        @Override
        protected void doQuery(BigdataSailRepositoryConnection cxn, OutputStream os) throws Exception {
            TupleQueryResultWriter w;
            BigdataSailTupleQuery query = (BigdataSailTupleQuery)this.setupQuery(cxn);
            if (this.xhtml) {
                String stylesheet = BigdataRDFContext.getEffectiveStringValue(this.req.getParameter(BigdataRDFContext.XSL_STYLESHEET), DEFAULT_XSL_STYLESHEET);
                MyXMLWriter xmlWriter = new MyXMLWriter(os, stylesheet);
                w = new SPARQLResultsXMLWriter((XMLWriter)xmlWriter);
            } else {
                TupleQueryResultFormat format = (TupleQueryResultFormat)TupleQueryResultWriterRegistry.getInstance().getFileFormatForMIMEType(this.mimeType);
                w = ((TupleQueryResultWriterFactory)TupleQueryResultWriterRegistry.getInstance().get((Object)format)).getWriter(os);
            }
            query.evaluate((TupleQueryResultHandler)w);
        }
    }

    private class AskQueryTask
    extends AbstractQueryTask {
        public AskQueryTask(BigdataSailRepositoryConnection cxn, String namespace, long timestamp, String baseURI, boolean includeInferred, Map<String, Value> bindings, ASTContainer astContainer, QueryType queryType, BooleanQueryResultFormat format, HttpServletRequest req, HttpServletResponse resp, OutputStream os) {
            super(cxn, namespace, timestamp, baseURI, includeInferred, bindings, astContainer, queryType, format.getDefaultMIMEType(), format.getCharset(), format.getDefaultFileExtension(), req, resp, os);
        }

        @Override
        protected void doQuery(BigdataSailRepositoryConnection cxn, OutputStream os) throws Exception {
            BigdataSailBooleanQuery query = (BigdataSailBooleanQuery)this.setupQuery(cxn);
            BooleanQueryResultFormat format = (BooleanQueryResultFormat)BooleanQueryResultWriterRegistry.getInstance().getFileFormatForMIMEType(this.mimeType);
            BooleanQueryResultWriter w = ((BooleanQueryResultWriterFactory)BooleanQueryResultWriterRegistry.getInstance().get((Object)format)).getWriter(os);
            boolean result = query.evaluate();
            w.write(result);
        }
    }

    public abstract class AbstractQueryTask
    implements Callable<Void> {
        private final BigdataSailRepositoryConnection cxn;
        private final String namespace;
        public final long timestamp;
        protected final String baseURI;
        protected final boolean includeInferred;
        protected final Map<String, Value> bindings;
        protected final ASTContainer astContainer;
        protected final boolean update;
        protected final QueryType queryType;
        protected final String mimeType;
        protected final Charset charset;
        protected final String fileExt;
        protected final HttpServletRequest req;
        protected final HttpServletResponse resp;
        protected final OutputStream os;
        protected final Long queryId;
        protected volatile UUID queryId2;
        protected AbstractOperation sailQueryOrUpdate;
        protected volatile Future<Void> updateFuture;
        final boolean explain;
        final boolean explainDetails;
        final boolean analytic;
        final boolean rto;
        final boolean xhtml;
        final boolean monitor;
        private volatile long beginNanos = 0L;
        private volatile long endNanos = 0L;

        public long getElapsedExecutionMillis() {
            if (this.beginNanos == 0L) {
                return 0L;
            }
            long now = this.endNanos;
            if (now == 0L) {
                now = System.nanoTime();
            }
            long elapsed = now - this.beginNanos;
            return TimeUnit.NANOSECONDS.toMillis(elapsed);
        }

        protected AbstractQueryTask(BigdataSailRepositoryConnection cxn, String namespace, long timestamp, String baseURI, boolean includeInferred, Map<String, Value> bindings, ASTContainer astContainer, QueryType queryType, String mimeType, Charset charset, String fileExt, HttpServletRequest req, HttpServletResponse resp, OutputStream os) {
            if (cxn == null) {
                throw new IllegalArgumentException();
            }
            if (namespace == null) {
                throw new IllegalArgumentException();
            }
            if (baseURI == null) {
                throw new IllegalArgumentException();
            }
            if (astContainer == null) {
                throw new IllegalArgumentException();
            }
            if (queryType == null) {
                throw new IllegalArgumentException();
            }
            if (mimeType == null) {
                throw new IllegalArgumentException();
            }
            if (fileExt == null) {
                throw new IllegalArgumentException();
            }
            if (req == null) {
                throw new IllegalArgumentException();
            }
            if (resp == null) {
                throw new IllegalArgumentException();
            }
            if (os == null) {
                throw new IllegalArgumentException();
            }
            this.cxn = cxn;
            this.namespace = namespace;
            this.timestamp = timestamp;
            this.baseURI = baseURI;
            this.includeInferred = includeInferred;
            this.bindings = bindings;
            this.astContainer = astContainer;
            this.update = false;
            this.queryType = queryType;
            this.mimeType = mimeType;
            this.charset = charset;
            this.fileExt = fileExt;
            this.req = req;
            this.resp = resp;
            this.explain = req.getParameter(BigdataRDFContext.EXPLAIN) != null;
            this.explainDetails = this.explain && BigdataRDFContext.isExplainDetails(req);
            this.analytic = BigdataRDFContext.getEffectiveBooleanValue(req.getParameter(BigdataRDFContext.ANALYTIC), QueryHints.DEFAULT_ANALYTIC);
            this.rto = BigdataRDFContext.getEffectiveBooleanValue(req.getParameter(BigdataRDFContext.RTO), QueryHints.DEFAULT_OPTIMIZER.equals((Object)QueryOptimizerEnum.Runtime));
            this.xhtml = BigdataRDFContext.getEffectiveBooleanValue(req.getParameter(BigdataRDFContext.XHTML), false);
            this.monitor = BigdataRDFContext.getEffectiveBooleanValue(req.getParameter(BigdataRDFContext.MONITOR), false);
            this.os = os;
            this.queryId = BigdataRDFContext.this.m_queryIdFactory.incrementAndGet();
        }

        protected AbstractQueryTask(BigdataSailRepositoryConnection cxn, String namespace, long timestamp, String baseURI, boolean includeInferred, Map<String, Value> bindings, ASTContainer astContainer, HttpServletRequest req, HttpServletResponse resp, OutputStream os) {
            if (cxn == null) {
                throw new IllegalArgumentException();
            }
            if (namespace == null) {
                throw new IllegalArgumentException();
            }
            if (baseURI == null) {
                throw new IllegalArgumentException();
            }
            if (astContainer == null) {
                throw new IllegalArgumentException();
            }
            if (req == null) {
                throw new IllegalArgumentException();
            }
            if (resp == null) {
                throw new IllegalArgumentException();
            }
            if (os == null) {
                throw new IllegalArgumentException();
            }
            this.cxn = cxn;
            this.namespace = namespace;
            this.timestamp = timestamp;
            this.baseURI = baseURI;
            this.includeInferred = includeInferred;
            this.bindings = bindings;
            this.astContainer = astContainer;
            this.update = true;
            this.queryType = null;
            this.mimeType = null;
            this.charset = Charset.forName("UTF-8");
            this.fileExt = null;
            this.req = req;
            this.resp = resp;
            this.explain = req.getParameter(BigdataRDFContext.EXPLAIN) != null;
            this.explainDetails = this.explain && BigdataRDFContext.isExplainDetails(req);
            this.analytic = BigdataRDFContext.getEffectiveBooleanValue(req.getParameter(BigdataRDFContext.ANALYTIC), QueryHints.DEFAULT_ANALYTIC);
            this.rto = BigdataRDFContext.getEffectiveBooleanValue(req.getParameter(BigdataRDFContext.RTO), QueryHints.DEFAULT_OPTIMIZER.equals((Object)QueryOptimizerEnum.Runtime));
            this.xhtml = BigdataRDFContext.getEffectiveBooleanValue(req.getParameter(BigdataRDFContext.XHTML), false);
            this.monitor = BigdataRDFContext.getEffectiveBooleanValue(req.getParameter(BigdataRDFContext.MONITOR), false);
            this.os = os;
            this.queryId = BigdataRDFContext.this.m_queryIdFactory.incrementAndGet();
        }

        protected void overrideDataset(AbstractOperation queryOrUpdate) {
            String[] defaultGraphURIs = this.req.getParameterValues(this.update ? BigdataRDFContext.USING_GRAPH_URI : BigdataRDFContext.DEFAULT_GRAPH_URI);
            String[] namedGraphURIs = this.req.getParameterValues(this.update ? BigdataRDFContext.USING_NAMED_GRAPH_URI : BigdataRDFContext.NAMED_GRAPH_URI);
            if (defaultGraphURIs != null || namedGraphURIs != null) {
                DatasetImpl dataset = new DatasetImpl();
                if (defaultGraphURIs != null) {
                    for (String graphURI : defaultGraphURIs) {
                        dataset.addDefaultGraph((URI)new URIImpl(graphURI));
                    }
                }
                if (namedGraphURIs != null) {
                    for (String graphURI : namedGraphURIs) {
                        dataset.addNamedGraph((URI)new URIImpl(graphURI));
                    }
                }
                queryOrUpdate.setDataset((Dataset)dataset);
            }
        }

        protected void setBindings(AbstractOperation queryOrUpdate) {
            for (Map.Entry<String, Value> binding : this.bindings.entrySet()) {
                queryOrUpdate.setBinding(binding.getKey(), binding.getValue());
            }
        }

        final AbstractQuery setupQuery(BigdataSailRepositoryConnection cxn) {
            long begin = System.nanoTime();
            AbstractQuery query = this.newQuery(cxn);
            UUID queryId2 = this.setQueryId(((BigdataSailQuery)query).getASTContainer());
            this.overrideDataset((AbstractOperation)query);
            this.setBindings((AbstractOperation)query);
            query.setIncludeInferred(this.includeInferred);
            if (this.analytic) {
                this.astContainer.setQueryHint(BigdataRDFContext.ANALYTIC, "true");
            }
            if (this.rto) {
                this.astContainer.setQueryHint("optimizer", QueryOptimizerEnum.Runtime.toString());
            }
            this.sailQueryOrUpdate = query;
            this.queryId2 = queryId2;
            RunningQuery r = new RunningQuery(this.queryId, queryId2, begin, this);
            BigdataRDFContext.this.m_queries.put(this.queryId, r);
            BigdataRDFContext.this.m_queries2.put(queryId2, r);
            return query;
        }

        final BigdataSailUpdate setupUpdate(BigdataSailRepositoryConnection cxn) {
            long begin = System.nanoTime();
            BigdataSailUpdate update = new BigdataSailUpdate(this.astContainer, cxn);
            UUID queryId2 = this.setQueryId(update.getASTContainer());
            this.overrideDataset((AbstractOperation)update);
            this.setBindings((AbstractOperation)update);
            if (this.analytic) {
                this.astContainer.setQueryHint(BigdataRDFContext.ANALYTIC, "true");
            }
            if (this.rto) {
                this.astContainer.setQueryHint("optimizer", QueryOptimizerEnum.Runtime.toString());
            }
            this.sailQueryOrUpdate = update;
            this.queryId2 = queryId2;
            RunningQuery r = new RunningQuery(this.queryId, queryId2, begin, this);
            BigdataRDFContext.this.m_queries.put(this.queryId, r);
            BigdataRDFContext.this.m_queries2.put(queryId2, r);
            QueryEngine queryEngine = QueryEngineFactory.getInstance().getQueryController(BigdataRDFContext.this.getIndexManager());
            if (queryEngine.pendingCancel(queryId2)) {
                this.updateFuture.cancel(true);
            }
            return update;
        }

        private AbstractQuery newQuery(BigdataSailRepositoryConnection cxn) {
            long queryTimeoutMillis = BigdataRDFContext.getQueryTimeout(this.req, BigdataRDFContext.this.getConfig().queryTimeout);
            if (queryTimeoutMillis > 0L) {
                QueryRoot originalQuery = this.astContainer.getOriginalAST();
                originalQuery.setTimeout(queryTimeoutMillis);
            }
            switch (this.queryType) {
                case SELECT: {
                    return new BigdataSailTupleQuery(this.astContainer, cxn);
                }
                case DESCRIBE: 
                case CONSTRUCT: {
                    return new BigdataSailGraphQuery(this.astContainer, cxn);
                }
                case ASK: {
                    return new BigdataSailBooleanQuery(this.astContainer, cxn);
                }
            }
            throw new RuntimeException("Unknown query type: " + (Object)((Object)this.queryType));
        }

        protected UUID setQueryId(ASTContainer astContainer) {
            assert (this.queryId2 == null);
            String queryIdStr = astContainer.getQueryHint("queryId");
            if (queryIdStr == null) {
                this.queryId2 = UUID.randomUUID();
                astContainer.setQueryHint("queryId", this.queryId2.toString());
            } else {
                this.queryId2 = UUID.fromString(queryIdStr);
            }
            return this.queryId2;
        }

        protected abstract void doQuery(BigdataSailRepositoryConnection var1, OutputStream var2) throws Exception;

        @Override
        public final Void call() throws Exception {
            return this.innerCall();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Void innerCall() throws Exception {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Query running...");
                }
                this.beginNanos = System.nanoTime();
                if (this.explain && !this.update) {
                    this.doQuery(this.cxn, new NullOutputStream());
                } else {
                    this.doQuery(this.cxn, this.os);
                    if (this.os instanceof PipedOutputStream) {
                        this.os.flush();
                        this.os.close();
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Query done.");
                }
                Void void_ = null;
                return void_;
            }
            finally {
                this.endNanos = System.nanoTime();
                BigdataRDFContext.this.m_queries.remove(this.queryId);
                if (this.queryId2 != null) {
                    BigdataRDFContext.this.m_queries2.remove(this.queryId2);
                }
            }
        }
    }

    static class TaskAndFutureTask<T> {
        public final AbstractRestApiTask<T> task;
        public final FutureTask<T> ft;
        public final long beginNanos;
        public UUID taskUuid;
        private final AtomicLong elapsedNanos = new AtomicLong(-1L);

        TaskAndFutureTask(AbstractRestApiTask<T> task, FutureTask<T> ft, long beginNanos) {
            this.task = task;
            this.ft = ft;
            this.beginNanos = beginNanos;
        }

        void done() {
            this.elapsedNanos.set(System.nanoTime() - this.beginNanos);
        }

        long getElapsedNanos() {
            long elapsedNanos = this.elapsedNanos.get();
            if (elapsedNanos == -1L) {
                return System.nanoTime() - this.beginNanos;
            }
            return elapsedNanos;
        }

        public com.bigdata.rdf.sail.model.RunningQuery getModelRunningQuery() {
            boolean isUpdateQuery = false;
            com.bigdata.rdf.sail.model.RunningQuery modelQuery = new com.bigdata.rdf.sail.model.RunningQuery(Long.toString(this.beginNanos), this.task.uuid, this.beginNanos, false);
            return modelQuery;
        }

        public long getMutationCount() {
            return this.task.getMutationCount();
        }
    }
}

