/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.config;

import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.config.BigdataRepositoryConfig;
import java.util.Properties;
import org.openrdf.repository.Repository;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryFactory;
import org.openrdf.repository.config.RepositoryImplConfig;

public class BigdataRepositoryFactory
implements RepositoryFactory {
    public static final String TYPE = "bigdata:BigdataRepository";

    public String getRepositoryType() {
        return TYPE;
    }

    public RepositoryImplConfig getConfig() {
        return new BigdataRepositoryConfig(TYPE);
    }

    public Repository getRepository(RepositoryImplConfig config) throws RepositoryConfigException {
        if (!TYPE.equals(config.getType())) {
            throw new RepositoryConfigException("Invalid type: " + config.getType());
        }
        if (!(config instanceof BigdataRepositoryConfig)) {
            throw new RepositoryConfigException("Invalid type: " + config.getClass());
        }
        try {
            BigdataRepositoryConfig bigdataConfig = (BigdataRepositoryConfig)config;
            Properties properties = bigdataConfig.getProperties();
            BigdataSail sail = new BigdataSail(properties);
            return new BigdataSailRepository(sail);
        }
        catch (Exception ex) {
            throw new RepositoryConfigException((Throwable)ex);
        }
    }
}

