/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.bench;

import com.bigdata.counters.CAT;
import com.bigdata.journal.TemporaryStore;
import com.bigdata.jsr166.LinkedBlockingQueue;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.openrdf.model.Graph;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerBase;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.query.resultio.sparqlxml.SPARQLResultsXMLParserFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.helpers.StatementCollector;

public class NanoSparqlClient {
    private static final Logger log = Logger.getLogger(NanoSparqlClient.class);
    static final String MIME_SPARQL_RESULTS_XML = "application/sparql-results+xml";
    static final String MIME_RDF_XML = "application/rdf+xml";
    private static final int DEFAULT_TIMEOUT = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFromFile(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException();
        }
        try (LineNumberReader r = new LineNumberReader(new FileReader(file));){
            String s;
            StringBuilder sb = new StringBuilder();
            while ((s = r.readLine()) != null) {
                if (r.getLineNumber() > 1) {
                    sb.append("\n");
                }
                sb.append(s);
            }
            String string = sb.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFromStdin() throws IOException {
        try (LineNumberReader r = new LineNumberReader(new InputStreamReader(System.in));){
            String s;
            StringBuilder sb = new StringBuilder();
            while ((s = r.readLine()) != null) {
                if (r.getLineNumber() > 1) {
                    sb.append("\n");
                }
                sb.append(s);
            }
            String string = sb.toString();
            return string;
        }
    }

    private static void getFiles(File fileOrDir, List<File> fileList) {
        if (fileOrDir.isHidden()) {
            return;
        }
        if (fileOrDir.isDirectory()) {
            File dir = fileOrDir;
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                NanoSparqlClient.getFiles(f, fileList);
            }
        } else {
            fileList.add(fileOrDir);
        }
    }

    private static final Map<String, String> readQueries(List<File> fileList, Pattern delim) throws IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (File file : fileList) {
            String s = NanoSparqlClient.readFromFile(file);
            if (delim == null) {
                map.put(file.toString(), s);
                continue;
            }
            String[] a = delim.split(s);
            int i = 1;
            for (String queryStr : a) {
                if (queryStr.trim().length() == 0) continue;
                map.put(file.toString() + "#" + i, queryStr);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Read query: file=" + file + ", index=" + i + ", query=" + queryStr));
                }
                ++i;
            }
        }
        return map;
    }

    private static int[] getRandomOrder(long seed, int n) {
        final Random rnd = new Random(seed);
        final class Pair
        implements Comparable<Pair> {
            public double r;
            public final int val;

            public Pair(int val) {
                this.r = rnd.nextDouble();
                this.val = val;
            }

            @Override
            public int compareTo(Pair other) {
                if (this == other) {
                    return 0;
                }
                if (this.r < other.r) {
                    return -1;
                }
                return 1;
            }
        }
        Object[] pairs = new Pair[n];
        for (int i = 0; i < n; ++i) {
            pairs[i] = new Pair(i);
        }
        Arrays.sort(pairs);
        int[] order = new int[n];
        for (int i = 0; i < n; ++i) {
            order[i] = ((Pair)pairs[i]).val;
        }
        return order;
    }

    private static int[] getQueryOrder(long seed, int repeat, int nqueries) {
        int i;
        int[] order;
        int ntrials = nqueries * repeat;
        if (seed == 0L) {
            order = new int[ntrials];
            for (i = 0; i < ntrials; ++i) {
                order[i] = i;
            }
        } else {
            order = NanoSparqlClient.getRandomOrder(seed, ntrials);
        }
        for (i = 0; i < ntrials; ++i) {
            order[i] = order[i] % nqueries;
        }
        return order;
    }

    private static Score[] getScores(Query[] queries) {
        Score[] a = new Score[queries.length];
        for (int i = 0; i < queries.length; ++i) {
            Query query = queries[i];
            a[i] = new Score(query);
        }
        return a;
    }

    private static void reportScores(Score[] a, long minMillisLatencyToReport) {
        Arrays.sort(a);
        System.out.println("average(ms)\tsource\tquery");
        for (int i = 0; i < a.length; ++i) {
            Score s = a[i];
            long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(s.elapsedNanos);
            if (elapsedMillis < minMillisLatencyToReport) continue;
            System.out.println(elapsedMillis + "\t" + s.query.source + "\t" + s.query.queryStr);
        }
    }

    private static void usage() {
        System.err.println("usage: (option)* [serviceURL] (query)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Query[] queries;
        int i;
        if (args.length == 0) {
            NanoSparqlClient.usage();
            System.exit(1);
        }
        long seed = System.nanoTime();
        int repeat = 1;
        long minLatencyToReport = 100L;
        File file = null;
        Pattern delim = null;
        String queryStr = null;
        boolean reportScores = false;
        int nclients = 1;
        boolean threadsPerClient = true;
        boolean groupQueriesBySource = false;
        long interGroupDelayMillis = 0L;
        QueryOptions opts = new QueryOptions();
        String mode = null;
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            String arg = args[i];
            if (arg.equals("-u")) {
                opts.username = args[++i];
                continue;
            }
            if (arg.equals("-p")) {
                opts.password = args[++i];
                continue;
            }
            if (arg.equals("-f")) {
                file = new File(args[++i]);
                continue;
            }
            if (arg.equals("-delim")) {
                delim = Pattern.compile(args[++i]);
                continue;
            }
            if (arg.equals("-showQuery")) {
                opts.showQuery = true;
                continue;
            }
            if (arg.equals("-explain")) {
                opts.explain = true;
                continue;
            }
            if (arg.equals("-analytic")) {
                opts.analytic = Boolean.valueOf(args[++i]);
                continue;
            }
            if (arg.equals("-showParseTree")) {
                opts.showParseTree = true;
                continue;
            }
            if (arg.equals("-showResults")) {
                opts.showResults = true;
                continue;
            }
            if (arg.equals("-reportScores")) {
                reportScores = true;
                continue;
            }
            if (arg.equals("-verbose")) {
                opts.verbose = true;
                opts.quiet = false;
                continue;
            }
            if (arg.equals("-quiet")) {
                opts.verbose = false;
                opts.quiet = true;
                continue;
            }
            if (arg.equals("-query")) {
                queryStr = args[++i];
                continue;
            }
            if (arg.equals("-clients")) {
                if ((nclients = Integer.valueOf(args[++i]).intValue()) >= 1) continue;
                throw new IllegalArgumentException("Bad clients.");
            }
            if (arg.equals("-repeat")) {
                if ((repeat = Integer.valueOf(args[++i]).intValue()) >= 1) continue;
                throw new IllegalArgumentException("Bad repeat.");
            }
            if (arg.equals("-seed")) {
                seed = Long.valueOf(args[++i]);
                continue;
            }
            if (arg.equals("-method")) {
                opts.method = args[++i].trim();
                if ("POST".equals(opts.method) || "GET".equals(opts.method)) continue;
                throw new IllegalArgumentException("Bad method: " + opts.method);
            }
            if (arg.equals("-useCaches")) {
                opts.useCaches = Boolean.valueOf(args[i++]);
                continue;
            }
            if (arg.equals("-timeout")) {
                if ((opts.timeout = Integer.valueOf(args[++i]).intValue()) < 0) {
                    throw new IllegalArgumentException("Bad timeout.");
                }
                if (!opts.verbose) continue;
                System.err.println("timeout: " + (opts.timeout == 0 ? "infinite" : "" + opts.timeout + "ms"));
                continue;
            }
            if (arg.equals("-defaultGraph")) {
                opts.defaultGraphUri = args[++i];
                if (!opts.verbose) continue;
                System.err.println("defaultGraph: " + opts.defaultGraphUri);
                continue;
            }
            if (arg.equals("-baseURI")) {
                opts.baseURI = args[++i];
                if (!opts.verbose) continue;
                System.err.println("baseURI: " + opts.baseURI);
                continue;
            }
            if (arg.equals("-help") || arg.equals("--?")) {
                NanoSparqlClient.usage();
                System.exit(1);
                continue;
            }
            if (arg.equals("-dbMode")) {
                mode = args[++i];
                continue;
            }
            throw new UnsupportedOperationException("Unknown option: " + arg);
        }
        if (i < args.length) {
            opts.serviceURL = args[i++];
            if (opts.verbose) {
                System.err.println("serviceURL: " + opts.serviceURL);
            }
        } else {
            NanoSparqlClient.usage();
            System.exit(1);
        }
        opts.tmpKb = NanoSparqlClient.createTempKb(mode);
        if (file != null) {
            if (opts.verbose) {
                System.err.println("Reading query(s) from file: " + file);
            }
            LinkedList<File> fileList = new LinkedList<File>();
            NanoSparqlClient.getFiles(file, fileList);
            Map<String, String> map = NanoSparqlClient.readQueries(fileList, delim);
            int nqueries = map.size();
            if (!opts.quiet) {
                System.err.println("Read " + nqueries + " queries from " + fileList.size() + " sources in " + file);
            }
            queries = new Query[nqueries];
            int i2 = 0;
            for (Map.Entry<String, String> e : map.entrySet()) {
                queries[i2++] = new Query(e.getKey(), e.getValue());
            }
        } else {
            String source;
            if (queryStr == null) {
                if (opts.verbose) {
                    System.err.println("Reading query from stdin...");
                }
                queryStr = NanoSparqlClient.readFromStdin();
                source = "stdin";
            } else {
                source = "command line";
            }
            queries = new Query[]{new Query(queryStr, source)};
        }
        long beginTrials = System.currentTimeMillis();
        AtomicLong nerrors = new AtomicLong();
        if (nclients == 1 && !groupQueriesBySource) {
            System.err.println("Running queries with with a single client");
            int[] order = NanoSparqlClient.getQueryOrder(seed, repeat, queries.length);
            for (int i3 = 0; i3 < order.length; ++i3) {
                int queryId = order[i3];
                Query query = queries[queryId];
                new RunQueryTask(query, opts, nerrors).run();
            }
        } else if (!groupQueriesBySource) {
            System.err.println("Running queries with parallel clients: nclients=" + nclients);
            int[] order = NanoSparqlClient.getQueryOrder(seed, repeat, queries.length);
            LinkedList<1> tasks = new LinkedList<1>();
            for (int i4 = 0; i4 < order.length; ++i4) {
                final RunQueryTask runnable = new RunQueryTask(queries[order[i4]], opts, nerrors);
                tasks.add(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        runnable.run();
                        return null;
                    }
                });
            }
            ExecutorService clientService = Executors.newFixedThreadPool(nclients);
            try {
                clientService.invokeAll(tasks);
            }
            finally {
                clientService.shutdownNow();
            }
        } else {
            throw new UnsupportedOperationException();
        }
        if (reportScores) {
            NanoSparqlClient.reportScores(NanoSparqlClient.getScores(queries), minLatencyToReport);
            System.out.println("Reporting only queries with at least " + minLatencyToReport + "ms latency.");
        }
        System.out.println("Total elapsed time: " + (System.currentTimeMillis() - beginTrials) + "ms for " + queries.length + " queries with " + repeat + " trials each and " + nclients + " clients.");
        System.exit(0);
    }

    private static AbstractTripleStore createTempKb(String mode) {
        TemporaryStore tempStore = new TemporaryStore();
        Properties p = new Properties();
        if (mode.equalsIgnoreCase("triples")) {
            p.setProperty(AbstractTripleStore.Options.TRIPLES_MODE, "true");
        } else if (mode.equalsIgnoreCase("quads")) {
            p.setProperty(AbstractTripleStore.Options.QUADS, "true");
            p.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, "com.bigdata.rdf.axioms.NoAxioms");
        } else if (mode.equalsIgnoreCase("provenance")) {
            p.setProperty(AbstractTripleStore.Options.TRIPLES_MODE_WITH_PROVENANCE, "true");
        }
        return new TempTripleStore(tempStore, p, null);
    }

    static class RunQueryTask
    implements Runnable {
        private final Query query;
        private final QueryOptions opts;
        private final AtomicLong nerrors;

        public RunQueryTask(Query query, QueryOptions opts, AtomicLong nerrors) {
            if (query == null) {
                throw new IllegalArgumentException();
            }
            if (opts == null) {
                throw new IllegalArgumentException();
            }
            if (nerrors == null) {
                throw new IllegalArgumentException();
            }
            this.query = query;
            this.opts = opts;
            this.nerrors = nerrors;
        }

        @Override
        public void run() {
            long begin = System.nanoTime();
            try {
                QueryTrial trial = this.query.runQuery(this.opts);
                if (!this.opts.quiet) {
                    System.out.println("resultCount=" + (trial.resultCount == -1L ? "N/A" : Long.valueOf(trial.resultCount)) + ", elapsed=" + TimeUnit.NANOSECONDS.toMillis(trial.elapsedNanos) + "ms, source=" + this.query.source);
                }
            }
            catch (Throwable t) {
                this.nerrors.incrementAndGet();
                long elapsedNanos = System.nanoTime() - begin;
                System.out.println("resultCount=ERR, elapsed=" + TimeUnit.NANOSECONDS.toMillis(elapsedNanos) + "ms, source=" + this.query.source);
                log.error((Object)("nerrors=" + this.nerrors + ", source=" + this.query.source + ", query=" + this.query.queryStr + ", cause=" + t));
            }
        }
    }

    private static class Score
    implements Comparable<Score> {
        public final Query query;
        public final long elapsedNanos;

        public Score(Query query) {
            this.query = query;
            this.elapsedNanos = query.elapsedNanos.get() / (long)query.trials.size();
        }

        @Override
        public int compareTo(Score o) {
            if (this.elapsedNanos < o.elapsedNanos) {
                return -1;
            }
            if (this.elapsedNanos > o.elapsedNanos) {
                return 1;
            }
            return 0;
        }
    }

    private static class Query {
        public final String source;
        public final String queryStr;
        public final LinkedBlockingQueue<QueryTrial> trials = new LinkedBlockingQueue();
        public final CAT elapsedNanos = new CAT();

        public Query(String source, String queryStr) {
            this.source = source;
            this.queryStr = queryStr;
        }

        public QueryTrial runQuery(QueryOptions opts) throws Exception {
            opts = opts.clone();
            opts.queryStr = this.queryStr;
            opts.source = this.source;
            try {
                new QueryTask(opts).call();
                QueryTrial trial = new QueryTrial(opts.elapsedNanos, opts.nresults);
                this.trials.add(trial);
                this.elapsedNanos.add(opts.elapsedNanos);
                return trial;
            }
            catch (Throwable t) {
                this.trials.add(new QueryTrial(t));
                throw new Exception(t);
            }
        }
    }

    private static class QueryTrial {
        private final long elapsedNanos;
        private final long resultCount;
        private final Throwable cause;

        public QueryTrial(long elapsedTime, long resultCount) {
            this.elapsedNanos = elapsedTime;
            this.resultCount = resultCount;
            this.cause = null;
        }

        public QueryTrial(Throwable cause) {
            this.elapsedNanos = -1L;
            this.resultCount = -1L;
            this.cause = cause;
        }
    }

    public static class QueryOptions
    implements Cloneable {
        public AbstractTripleStore tmpKb;
        public String serviceURL = null;
        public String username = null;
        public String password = null;
        public String source;
        public String queryStr;
        public String baseURI;
        public String defaultGraphUri = null;
        public boolean explain = false;
        public Boolean analytic = null;
        public int timeout = 0;
        public String method = "GET";
        public boolean useCaches = true;
        public boolean showQuery = false;
        public boolean showParseTree = false;
        public boolean showResults = false;
        public boolean verbose = false;
        public boolean quiet = false;
        public QueryType queryType = null;
        public long nresults = 0L;
        public long elapsedNanos = 0L;

        public QueryOptions() {
            this(null, null);
        }

        public QueryOptions(String serviceURL, String queryStr) {
            this.serviceURL = serviceURL;
            this.queryStr = queryStr;
        }

        public QueryOptions clone() {
            try {
                return (QueryOptions)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class QueryTask
    implements Callable<Void> {
        final QueryOptions opts;

        public QueryTask(QueryOptions opts) {
            if (opts == null) {
                throw new IllegalArgumentException();
            }
            this.opts = opts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.nanoTime();
            ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2(this.opts.queryStr, this.opts.baseURI);
            QueryType queryType = this.opts.queryType = astContainer.getOriginalAST().getQueryType();
            if (this.opts.showQuery) {
                System.err.println("---- " + Thread.currentThread().getName() + " : Query " + (this.opts.source == null ? "" : " : " + this.opts.source) + "----");
                System.err.println(this.opts.queryStr);
            }
            if (this.opts.showParseTree) {
                System.err.println("----- Parse Tree " + (this.opts.source == null ? "" : " : " + this.opts.source) + "-----");
                System.err.println(astContainer.getOriginalAST().toString());
            }
            String urlString = this.opts.serviceURL + "?query=" + URLEncoder.encode(this.opts.queryStr, "UTF-8") + (this.opts.explain ? "&explain=" : "") + (this.opts.analytic != null ? "&analytic=" + this.opts.analytic : "") + (this.opts.defaultGraphUri == null ? "" : "&default-graph-uri=" + URLEncoder.encode(this.opts.defaultGraphUri, "UTF-8"));
            URL url = new URL(urlString);
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod(this.opts.method);
                conn.setDoOutput(true);
                conn.setUseCaches(this.opts.useCaches);
                conn.setReadTimeout(this.opts.timeout);
                switch (queryType) {
                    case DESCRIBE: 
                    case CONSTRUCT: {
                        conn.setRequestProperty("Accept", NanoSparqlClient.MIME_RDF_XML);
                        break;
                    }
                    case ASK: 
                    case SELECT: {
                        conn.setRequestProperty("Accept", NanoSparqlClient.MIME_SPARQL_RESULTS_XML);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("QueryType: " + (Object)((Object)queryType));
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"*** Request ***");
                    log.debug((Object)this.opts.serviceURL);
                    log.debug((Object)this.opts.queryStr);
                }
                conn.connect();
                int rc = conn.getResponseCode();
                if (rc < 200 || rc >= 300) {
                    throw new IOException(rc + " : " + conn.getResponseMessage() + " : " + url);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"*** Response ***");
                    log.debug((Object)("Status Line: " + conn.getResponseMessage()));
                }
                if (this.opts.explain || this.opts.showResults) {
                    this.showResults(conn);
                    this.opts.nresults = -1L;
                } else {
                    long nresults;
                    switch (queryType) {
                        case DESCRIBE: 
                        case CONSTRUCT: {
                            nresults = this.buildGraph(conn).size();
                            break;
                        }
                        case ASK: 
                        case SELECT: {
                            nresults = this.countResults(conn);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("QueryType: " + (Object)((Object)queryType));
                        }
                    }
                    this.opts.nresults = nresults;
                }
                Void void_ = null;
                return void_;
            }
            finally {
                this.opts.elapsedNanos = System.nanoTime() - begin;
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void showResults(HttpURLConnection conn) throws Exception {
            try (LineNumberReader r = new LineNumberReader(new InputStreamReader(conn.getInputStream(), conn.getContentEncoding() == null ? "ISO-8859-1" : conn.getContentEncoding()));){
                String s;
                while ((s = r.readLine()) != null) {
                    System.out.println(s);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long countResults(HttpURLConnection conn) throws Exception {
            final AtomicLong nsolutions = new AtomicLong();
            TupleQueryResultParser parser = new SPARQLResultsXMLParserFactory().getParser();
            parser.setTupleQueryResultHandler((TupleQueryResultHandler)new TupleQueryResultHandlerBase(){

                public void endQueryResult() {
                }

                public void handleSolution(BindingSet bset) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)bset.toString());
                    }
                    nsolutions.incrementAndGet();
                }

                public void startQueryResult(List<String> bindingNames) {
                }
            });
            parser.parse(conn.getInputStream());
            if (log.isInfoEnabled()) {
                log.info((Object)("nsolutions=" + nsolutions));
            }
            long l = nsolutions.longValue();
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Graph buildGraph(HttpURLConnection conn) throws Exception {
            GraphImpl g = new GraphImpl();
            String baseURI = "";
            RDFParser rdfParser = ((RDFParserFactory)RDFParserRegistry.getInstance().get((Object)RDFFormat.RDFXML)).getParser();
            rdfParser.setVerifyData(true);
            rdfParser.setStopAtFirstError(true);
            rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)g));
            rdfParser.parse(conn.getInputStream(), "");
            GraphImpl graphImpl = g;
            return graphImpl;
        }
    }
}

