/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.model;

import com.bigdata.rdf.model.BigdataResourceImpl;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import org.openrdf.model.URI;
import org.openrdf.model.util.URIUtil;

public class BigdataURIImpl
extends BigdataResourceImpl
implements BigdataURI {
    private static final long serialVersionUID = 3018590380571802474L;
    private final String uriString;
    private int indexOf = -1;

    BigdataURIImpl(BigdataValueFactory valueFactory, String uriString) {
        super(valueFactory, null);
        if (uriString == null) {
            throw new IllegalArgumentException();
        }
        if (uriString.indexOf(58) == -1) {
            throw new IllegalArgumentException(uriString);
        }
        this.uriString = uriString;
    }

    public String toString() {
        return this.uriString;
    }

    public String getNamespace() {
        if (this.indexOf == -1) {
            this.indexOf = URIUtil.getLocalNameIndex((String)this.uriString);
        }
        return this.uriString.substring(0, this.indexOf);
    }

    @Override
    public int getNamespaceLength() {
        if (this.indexOf == -1) {
            this.indexOf = URIUtil.getLocalNameIndex((String)this.uriString);
        }
        return this.indexOf;
    }

    @Override
    public int getLocalNameLength() {
        if (this.indexOf == -1) {
            this.indexOf = URIUtil.getLocalNameIndex((String)this.uriString);
        }
        return this.uriString.length() - (this.indexOf + 1);
    }

    public String getLocalName() {
        if (this.indexOf == -1) {
            this.indexOf = URIUtil.getLocalNameIndex((String)this.uriString);
        }
        return this.uriString.substring(this.indexOf);
    }

    public String stringValue() {
        return this.uriString;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof URI)) {
            return false;
        }
        return this.equals((URI)o);
    }

    public final boolean equals(URI o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof BigdataValue && this.isRealIV() && ((BigdataValue)o).isRealIV() && ((BigdataValue)o).getValueFactory() == this.getValueFactory()) {
            boolean equals = this.getIV().equals(((BigdataValue)o).getIV());
            return equals;
        }
        return this.uriString.equals(o.stringValue());
    }

    public final int hashCode() {
        return this.uriString.hashCode();
    }
}

