/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.BatchLookup;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.lexicon.ITermCache;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

class ResolveTermTask
implements Callable<Void> {
    private static final transient Logger log = Logger.getLogger(ResolveTermTask.class);
    private final IIndex ndx;
    private final int fromIndex;
    private final int toIndex;
    private final byte[][] keys;
    private final TermId<?>[] notFound;
    private final ConcurrentHashMap<IV<?, ?>, BigdataValue> map;
    private final ITermCache<IV<?, ?>, BigdataValue> termCache;
    private final BigdataValueFactory valueFactory;

    ResolveTermTask(IIndex ndx, int fromIndex, int toIndex, byte[][] keys, TermId<?>[] notFound, ConcurrentHashMap<IV<?, ?>, BigdataValue> map, ITermCache<IV<?, ?>, BigdataValue> termCache, BigdataValueFactory valueFactory) {
        this.ndx = ndx;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.keys = keys;
        this.notFound = notFound;
        this.map = map;
        this.termCache = termCache;
        this.valueFactory = valueFactory;
    }

    @Override
    public Void call() {
        AbstractKeyArrayIndexProcedure.ResultBufferHandler resultHandler = new AbstractKeyArrayIndexProcedure.ResultBufferHandler(this.toIndex, this.ndx.getIndexMetadata().getTupleSerializer().getLeafValuesCoder());
        this.ndx.submit(this.fromIndex, this.toIndex, this.keys, null, BatchLookup.BatchLookupConstructor.INSTANCE, resultHandler);
        AbstractKeyArrayIndexProcedure.ResultBuffer results = resultHandler.getResult();
        IRaba vals = results.getValues();
        for (int i = this.fromIndex; i < this.toIndex; ++i) {
            TermId<?> tid = this.notFound[i];
            byte[] data = vals.get(i);
            if (data == null) {
                log.warn((Object)("No such term: " + tid));
                continue;
            }
            BigdataValue value = this.valueFactory.getValueSerializer().deserialize(data);
            value.setIV(tid);
            BigdataValue tmp = this.termCache.putIfAbsent(tid, value);
            if (tmp != null) {
                value = tmp;
            }
            assert (value.getIV().equals(tid)) : "expecting tid=" + tid + ", but found " + value.getIV();
            assert (value.getValueFactory() == this.valueFactory);
            this.map.put(tid, value);
        }
        return null;
    }
}

