/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.literal;

import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class XSDUnsignedLongIV<V extends BigdataLiteral>
extends AbstractLiteralIV<V, BigInteger> {
    private static final long serialVersionUID = 1L;
    private final long value;
    private static final long UNSIGNED_ZERO = Long.MIN_VALUE;

    public long rawValue() {
        return this.value;
    }

    @Override
    public IV<V, BigInteger> clone(boolean clearCache) {
        XSDUnsignedLongIV tmp = new XSDUnsignedLongIV(this.value);
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public XSDUnsignedLongIV(long value) {
        super(DTE.XSDUnsignedLong);
        this.value = value;
    }

    public final BigInteger promote() {
        return XSDUnsignedLongIV.promote(this.value);
    }

    public static BigInteger promote(long value) {
        return BigInteger.valueOf(value).subtract(BigInteger.valueOf(Long.MIN_VALUE));
    }

    @Override
    public final BigInteger getInlineValue() {
        return this.promote();
    }

    @Override
    public V asValue(LexiconRelation lex) {
        BigdataLiteral v = (BigdataLiteral)this.getValueCache();
        if (v == null) {
            BigdataValueFactory f = lex.getValueFactory();
            v = f.createLiteral(this.value, true);
            v.setIV(this);
            this.setValue(v);
        }
        return (V)v;
    }

    @Override
    public final long longValue() {
        return this.promote().longValue();
    }

    @Override
    public boolean booleanValue() {
        return this.value != Long.MIN_VALUE;
    }

    @Override
    public byte byteValue() {
        return this.promote().byteValue();
    }

    @Override
    public double doubleValue() {
        return this.promote().doubleValue();
    }

    @Override
    public float floatValue() {
        return this.promote().floatValue();
    }

    @Override
    public int intValue() {
        return this.promote().intValue();
    }

    @Override
    public short shortValue() {
        return this.promote().shortValue();
    }

    @Override
    public String stringValue() {
        return this.promote().toString();
    }

    @Override
    public BigDecimal decimalValue() {
        return new BigDecimal(this.promote());
    }

    @Override
    public BigInteger integerValue() {
        return this.promote();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof XSDUnsignedLongIV) {
            return this.value == ((XSDUnsignedLongIV)o).value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public int byteLength() {
        return 9;
    }

    @Override
    public int _compareTo(IV o) {
        XSDUnsignedLongIV t = (XSDUnsignedLongIV)o;
        return this.value == t.value ? 0 : (this.value < t.value ? -1 : 1);
    }
}

