/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.literal;

import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.NumericIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.openrdf.model.Literal;

public class XSDNumericIV<V extends BigdataLiteral>
extends NumericIV<V, Number>
implements Literal {
    private static final long serialVersionUID = 2330208360371357672L;
    private final Number number;

    @Override
    public IV<V, Number> clone(boolean clearCache) {
        XSDNumericIV tmp = new XSDNumericIV(this.number, this.getDTE());
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    private XSDNumericIV(Number number, DTE dte) {
        super(dte);
        this.number = number;
    }

    public XSDNumericIV(byte number) {
        this(number, DTE.XSDByte);
    }

    public XSDNumericIV(short number) {
        this(number, DTE.XSDShort);
    }

    public XSDNumericIV(int number) {
        this(number, DTE.XSDInt);
    }

    public XSDNumericIV(long number) {
        this(number, DTE.XSDLong);
    }

    public XSDNumericIV(float number) {
        this(Float.valueOf(number), DTE.XSDFloat);
    }

    public XSDNumericIV(double number) {
        this(number, DTE.XSDDouble);
    }

    @Override
    public final Number getInlineValue() {
        return this.number;
    }

    @Override
    public boolean booleanValue() {
        switch (this.getDTE()) {
            case XSDByte: {
                return this.byteValue() != 0;
            }
            case XSDShort: {
                return this.shortValue() != 0;
            }
            case XSDInt: {
                return this.intValue() != 0;
            }
            case XSDLong: {
                return this.longValue() != 0L;
            }
        }
        return super.booleanValue();
    }

    @Override
    public byte byteValue() {
        return this.number.byteValue();
    }

    @Override
    public short shortValue() {
        return this.number.shortValue();
    }

    @Override
    public int intValue() {
        return this.number.intValue();
    }

    @Override
    public long longValue() {
        return this.number.longValue();
    }

    @Override
    public float floatValue() {
        return this.number.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.number.doubleValue();
    }

    @Override
    public BigInteger integerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    @Override
    public BigDecimal decimalValue() {
        switch (this.getDTE()) {
            case XSDByte: 
            case XSDShort: 
            case XSDInt: 
            case XSDLong: {
                return BigDecimal.valueOf(this.longValue());
            }
            case XSDFloat: 
            case XSDDouble: {
                return BigDecimal.valueOf(this.doubleValue());
            }
        }
        throw new RuntimeException("unknown DTE");
    }

    @Override
    public V asValue(LexiconRelation lex) {
        BigdataLiteral v = (BigdataLiteral)this.getValueCache();
        if (v == null) {
            switch (this.getDTE()) {
                case XSDByte: {
                    v = lex.getValueFactory().createLiteral(this.byteValue());
                    break;
                }
                case XSDShort: {
                    v = lex.getValueFactory().createLiteral(this.shortValue());
                    break;
                }
                case XSDInt: {
                    v = lex.getValueFactory().createLiteral(this.intValue());
                    break;
                }
                case XSDLong: {
                    v = lex.getValueFactory().createLiteral(this.longValue());
                    break;
                }
                case XSDFloat: {
                    v = lex.getValueFactory().createLiteral(this.floatValue());
                    break;
                }
                case XSDDouble: {
                    v = lex.getValueFactory().createLiteral(this.doubleValue());
                    break;
                }
                default: {
                    throw new RuntimeException("unknown DTE");
                }
            }
            v.setIV(this);
            this.setValue(v);
        }
        return (V)v;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof XSDNumericIV) {
            XSDNumericIV n = (XSDNumericIV)o;
            return this.getDTE() == n.getDTE() && this.number.equals(n.number);
        }
        return false;
    }

    @Override
    public int _compareTo(IV o) {
        XSDNumericIV n = (XSDNumericIV)o;
        switch (this.getDTE()) {
            case XSDByte: {
                return this.byteValue() == n.byteValue() ? 0 : (this.byteValue() < n.byteValue() ? -1 : 1);
            }
            case XSDShort: {
                return this.shortValue() == n.shortValue() ? 0 : (this.shortValue() < n.shortValue() ? -1 : 1);
            }
            case XSDInt: {
                return this.intValue() == n.intValue() ? 0 : (this.intValue() < n.intValue() ? -1 : 1);
            }
            case XSDLong: {
                return this.longValue() == n.longValue() ? 0 : (this.longValue() < n.longValue() ? -1 : 1);
            }
            case XSDFloat: {
                return Float.compare(this.floatValue(), n.floatValue());
            }
            case XSDDouble: {
                return Double.compare(this.doubleValue(), n.doubleValue());
            }
        }
        throw new RuntimeException("unknown DTE");
    }

    @Override
    public int hashCode() {
        switch (this.getDTE()) {
            case XSDByte: {
                return this.byteValue();
            }
            case XSDShort: {
                return this.shortValue();
            }
            case XSDInt: {
                return this.intValue();
            }
            case XSDLong: {
                return (int)(this.longValue() ^ this.longValue() >>> 32);
            }
            case XSDFloat: {
                return Float.floatToIntBits(this.floatValue());
            }
            case XSDDouble: {
                long l = Double.doubleToLongBits(this.doubleValue());
                return (int)(l ^ l >>> 32);
            }
        }
        throw new RuntimeException("unknown DTE");
    }

    @Override
    public int byteLength() {
        switch (this.getDTE()) {
            case XSDByte: {
                return 2;
            }
            case XSDShort: {
                return 3;
            }
            case XSDInt: {
                return 5;
            }
            case XSDLong: {
                return 9;
            }
            case XSDFloat: {
                return 5;
            }
            case XSDDouble: {
                return 9;
            }
        }
        throw new RuntimeException("unknown DTE");
    }
}

