/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.literal;

import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.DTEExtension;
import com.bigdata.rdf.internal.IPv4Address;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.util.BytesUtil;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;

public class IPv4AddrIV<V extends BigdataLiteral>
extends AbstractLiteralIV<V, IPv4Address>
implements Serializable,
Literal {
    private static final long serialVersionUID = 685148537376856907L;
    private static final transient Logger log = Logger.getLogger(IPv4AddrIV.class);
    private final IPv4Address value;
    private transient String hostAddress;
    private transient V uri;
    private static final transient String IPv4_OPTIONAL_CIDR_PATTERN = "((([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5]))(\\/([012]?\\d|3[012]))?";
    private static final transient Pattern pattern = Pattern.compile("((([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5]))(\\/([012]?\\d|3[012]))?");

    @Override
    public IV<V, IPv4Address> clone(boolean clearCache) {
        IPv4AddrIV tmp = new IPv4AddrIV(this.value);
        tmp.uri = this.uri;
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public IPv4AddrIV(IPv4Address value) {
        super(DTE.Extension);
        this.value = value;
    }

    public IPv4AddrIV(String hostAddress) throws UnknownHostException {
        super(DTE.Extension);
        this.hostAddress = hostAddress;
        Matcher matcher = pattern.matcher(hostAddress);
        boolean matches = matcher.matches();
        if (matches) {
            String[] s;
            String ip = matcher.group(1);
            if (log.isDebugEnabled()) {
                log.debug((Object)ip);
            }
            String suffix = matcher.group(6);
            if (log.isDebugEnabled()) {
                log.debug((Object)suffix);
            }
            if (suffix != null) {
                s = new String[5];
                System.arraycopy(ip.split("\\.", -1), 0, s, 0, 4);
                s[4] = suffix;
            } else {
                s = ip.split("\\.", -1);
            }
            this.value = IPv4Address.IPv4Factory(s);
            if (this.value == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("not a valid IP: " + hostAddress));
                }
                throw new UnknownHostException("not a valid IP: " + hostAddress);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)this.value);
                log.debug((Object)this.byteLength());
                log.debug((Object)BytesUtil.toString((byte[])this.value.getBytes()));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("not a valid IP: " + hostAddress));
            }
            throw new UnknownHostException("Did not match REGEX - not a valid IP: " + hostAddress);
        }
    }

    @Override
    public DTEExtension getDTEX() {
        return DTEExtension.IPV4;
    }

    @Override
    public IPv4Address getInlineValue() throws UnsupportedOperationException {
        return this.value;
    }

    @Override
    public V asValue(LexiconRelation lex) {
        if (this.uri == null) {
            this.uri = lex.getValueFactory().createLiteral(this.getLabel(), XSD.IPV4);
            this.uri.setIV((IV)this);
        }
        return this.uri;
    }

    @Override
    public int byteLength() {
        return 2 + this.value.getBytes().length;
    }

    @Override
    public String toString() {
        return "IPv4(" + this.getLabel() + ")";
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String getLabel() {
        if (this.hostAddress == null) {
            this.hostAddress = this.value.toString();
        }
        return this.hostAddress;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IPv4AddrIV) {
            IPv4Address value2 = ((IPv4AddrIV)o).value;
            return this.value.equals(value2);
        }
        return false;
    }

    @Override
    public int _compareTo(IV o) {
        return this.value.compareTo(((IPv4AddrIV)o).value);
    }

    public static Matcher getIPv4Matcher(String addr) {
        return pattern.matcher(addr);
    }
}

