/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.ISuffixedURIHandler;
import com.bigdata.rdf.internal.InlineLocalNameIntegerURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.model.BigdataLiteral;

public class InlineSuffixedFixedWidthIntegerURIHandler
extends InlineLocalNameIntegerURIHandler
implements ISuffixedURIHandler {
    private String suffix = null;
    private int width = 0;

    public InlineSuffixedFixedWidthIntegerURIHandler(String namespace, String suffix, int width) {
        super(namespace);
        this.suffix = suffix;
        this.width = width;
    }

    public InlineSuffixedFixedWidthIntegerURIHandler(String namespace, String suffix, int width, int id) {
        super(namespace);
        this.suffix = suffix;
        this.width = width;
        this.packedId = id;
    }

    @Override
    protected AbstractLiteralIV createInlineIV(String localName) {
        if (!localName.endsWith(this.suffix)) {
            return null;
        }
        String intValue = localName.substring(0, localName.length() - this.suffix.length());
        return super.createInlineIV(this.getPackedValueString(intValue));
    }

    @Override
    public String getLocalNameFromDelegate(AbstractLiteralIV<BigdataLiteral, ?> delegate) {
        String intStr = super.getLocalNameFromDelegate(delegate);
        int intVal = (int)this.getUnpackedValueFromString(intStr);
        String localName = String.format("%0" + this.width + "d", intVal) + this.suffix;
        return localName;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

