/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.quorum;

import com.bigdata.ha.HAGlue;
import com.bigdata.ha.QuorumService;

public class QuorumTokenTransitions {
    final long currentQuorumToken;
    final long newQuorumToken;
    final long currentHAReadyToken;
    public final boolean didBreak;
    public final boolean didMeet;
    public final boolean didJoinMetQuorum;
    public final boolean didLeaveMetQuorum;
    private final boolean wasMet;
    private final boolean isMet;
    private final boolean isJoined;
    private final boolean wasJoined;

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass());
        sb.append("{oldQuorumToken=" + this.currentQuorumToken);
        sb.append(",newQuorumToken=" + this.newQuorumToken);
        sb.append(",oldHAReadyToken=" + this.currentHAReadyToken);
        sb.append(",didBreak=" + this.didBreak);
        sb.append(",didMeet=" + this.didMeet);
        sb.append(",didJoinMetQuorum=" + this.didJoinMetQuorum);
        sb.append(",didLeaveMetQuorum=" + this.didLeaveMetQuorum);
        sb.append("}");
        return sb.toString();
    }

    public QuorumTokenTransitions(long currentQuorumToken, long newQuorumToken, QuorumService<HAGlue> service, long haReady) {
        this(currentQuorumToken, newQuorumToken, service != null && service.isJoinedMember(newQuorumToken), haReady);
    }

    public QuorumTokenTransitions(long currentQuorumToken, long newQuorumToken, boolean joined, long haReady) {
        boolean noTokenChange;
        this.currentHAReadyToken = haReady;
        this.currentQuorumToken = currentQuorumToken;
        this.newQuorumToken = newQuorumToken;
        this.isJoined = joined;
        this.wasJoined = haReady != -1L;
        this.wasMet = currentQuorumToken != -1L;
        this.isMet = newQuorumToken != -1L;
        boolean bl = noTokenChange = currentQuorumToken == newQuorumToken && currentQuorumToken == this.currentHAReadyToken;
        if (noTokenChange && this.isJoined) {
            this.didBreak = false;
            this.didMeet = false;
            this.didJoinMetQuorum = this.didJoin();
            this.didLeaveMetQuorum = false;
        } else if (this.isBreak()) {
            this.didBreak = true;
            this.didMeet = false;
            this.didJoinMetQuorum = false;
            this.didLeaveMetQuorum = this.wasJoined;
        } else if (this.isMeet()) {
            this.didBreak = false;
            this.didMeet = true;
            this.didJoinMetQuorum = false;
            this.didLeaveMetQuorum = false;
        } else if (this.didJoin()) {
            this.didBreak = false;
            this.didMeet = false;
            this.didJoinMetQuorum = true;
            this.didLeaveMetQuorum = false;
        } else if (this.didLeaveMet()) {
            this.didBreak = false;
            this.didMeet = false;
            this.didJoinMetQuorum = false;
            this.didLeaveMetQuorum = true;
        } else {
            this.didBreak = false;
            this.didMeet = false;
            this.didJoinMetQuorum = false;
            this.didLeaveMetQuorum = false;
        }
        this.checkStates();
    }

    private void checkStates() {
        if (this.wasJoined && this.wasMet && this.currentHAReadyToken > this.currentQuorumToken) {
            throw new AssertionError((Object)"haReady greater than current token");
        }
        if (this.wasMet && this.isMet && this.newQuorumToken < this.currentQuorumToken) {
            throw new AssertionError((Object)"next token less than current token");
        }
        if (this.wasMet && this.isMet && this.newQuorumToken != this.currentQuorumToken) {
            throw new AssertionError((Object)("New quorum token without quorum break first, current: " + this.currentQuorumToken + ", new: " + this.newQuorumToken));
        }
        if (this.didMeet && this.didJoinMetQuorum) {
            throw new AssertionError((Object)"didMeet && didJoinMetQuorum");
        }
    }

    private final boolean isBreak() {
        return this.wasMet && !this.isMet;
    }

    private final boolean isMeet() {
        return this.isMet & !this.wasMet;
    }

    private final boolean didJoin() {
        return this.isMet && this.isJoined && !this.wasJoined;
    }

    private final boolean didLeaveMet() {
        return this.isMet && this.wasJoined && !this.isJoined;
    }
}

