/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.journal.TemporaryRawStore;
import com.bigdata.journal.TemporaryStore;
import com.bigdata.rawstore.WormAddressManager;
import com.bigdata.util.InnerCause;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;

public class TemporaryStoreFactory {
    private static final transient Logger log = Logger.getLogger(TemporaryStoreFactory.class);
    private WeakReference<TemporaryStore> ref = null;
    private final File tmpDir;
    private final int offsetBits;
    private final long maxExtent;
    private ConcurrentWeakValueCache<UUID, TemporaryStore> stores = new ConcurrentWeakValueCache(0);

    public TemporaryStoreFactory() {
        this(new File(System.getProperty(Options.TMP_DIR, System.getProperty("java.io.tmpdir"))), Integer.valueOf(System.getProperty(Options.OFFSET_BITS, "42")), Long.valueOf(System.getProperty(Options.MAX_EXTENT, "1073741824")));
    }

    public TemporaryStoreFactory(Properties properties) {
        this(new File(properties.getProperty(Options.TMP_DIR, System.getProperty("java.io.tmpdir"))), Integer.valueOf(properties.getProperty(Options.OFFSET_BITS, "42")), Long.valueOf(properties.getProperty(Options.MAX_EXTENT, "1073741824")));
    }

    public TemporaryStoreFactory(File tmpDir, int offsetBits, long maxExtent) {
        if (tmpDir == null) {
            throw new IllegalArgumentException();
        }
        WormAddressManager.assertOffsetBits(offsetBits);
        if (maxExtent < 0L) {
            throw new IllegalArgumentException();
        }
        this.tmpDir = tmpDir;
        this.offsetBits = offsetBits;
        this.maxExtent = maxExtent;
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.TMP_DIR + "=" + tmpDir));
            log.info((Object)(Options.OFFSET_BITS + "=" + offsetBits));
            log.info((Object)(Options.MAX_EXTENT + "=" + maxExtent));
        }
    }

    public synchronized TemporaryStore getTempStore() {
        TemporaryStore t;
        TemporaryStore temporaryStore = t = this.ref == null ? null : (TemporaryStore)this.ref.get();
        if (t == null || t.getBufferStrategy().getExtent() > this.maxExtent) {
            File file = TemporaryRawStore.getTempFile(this.tmpDir);
            t = new TemporaryStore(this.offsetBits, file);
            this.stores.put((Object)t.getUUID(), (Object)t);
            this.ref = new WeakReference<TemporaryStore>(t);
        }
        return t;
    }

    public synchronized void closeAll() {
        boolean interrupted = false;
        Iterator itr = this.stores.entryIterator();
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            TemporaryStore store = (TemporaryStore)((WeakReference)entry.getValue()).get();
            if (store == null || !store.isOpen()) continue;
            try {
                store.close();
            }
            catch (Throwable t) {
                if (!InnerCause.isInnerCause((Throwable)t, InterruptedException.class)) continue;
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static interface Options {
        public static final String TMP_DIR = TemporaryStoreFactory.class.getName() + ".tmpDir";
        public static final String JAVA_TMP_DIR_PROPERTY = "java.io.tmpdir";
        public static final String OFFSET_BITS = TemporaryStoreFactory.class.getName() + ".offsetBits";
        public static final String DEFAULT_OFFSET_BITS = "42";
        public static final String MAX_EXTENT = TemporaryStoreFactory.class.getName() + ".maxExtent";
        public static final String DEFAULT_MAX_EXTENT = "1073741824";
    }
}

