/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.io.FileChannelUtility;
import com.bigdata.io.IReopenChannel;
import com.bigdata.journal.BasicBufferStrategy;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.FileMetadata;
import com.bigdata.journal.ForceEnum;
import com.bigdata.journal.IDiskBasedStrategy;
import com.bigdata.journal.IRootBlockView;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public abstract class DiskBackedBufferStrategy
extends BasicBufferStrategy
implements IDiskBasedStrategy {
    final File file;
    final String fileMode;
    RandomAccessFile raf;
    protected final IReopenChannel<FileChannel> opener = new IReopenChannel<FileChannel>(){

        @Override
        public String toString() {
            return DiskBackedBufferStrategy.this.file.toString();
        }

        @Override
        public FileChannel reopenChannel() throws IOException {
            return DiskBackedBufferStrategy.this.reopenChannel();
        }
    };

    @Override
    public final int getHeaderSize() {
        return this.headerSize;
    }

    @Override
    public final File getFile() {
        return this.file;
    }

    @Override
    public final RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    @Override
    public final FileChannel getChannel() {
        return this.getRandomAccessFile().getChannel();
    }

    @Override
    public final boolean isStable() {
        return true;
    }

    @Override
    public void delete(long addr) {
    }

    @Override
    public void force(boolean metadata) {
        try {
            this.getChannel().force(metadata);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        try {
            DiskBackedBufferStrategy diskBackedBufferStrategy = this;
            synchronized (diskBackedBufferStrategy) {
                if (this.raf != null && this.raf.getChannel().isOpen()) {
                    this.raf.close();
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void deleteResources() {
        if (this.isOpen()) {
            throw new IllegalStateException();
        }
        if (this.file.exists() && !this.file.delete()) {
            log.warn((Object)("Could not delete file: " + this.file.getAbsoluteFile()));
        }
    }

    DiskBackedBufferStrategy(long maximumExtent, BufferMode bufferMode, FileMetadata fileMetadata) {
        super(maximumExtent, fileMetadata.offsetBits, fileMetadata.nextOffset, 688, fileMetadata.extent, bufferMode, fileMetadata.buffer, fileMetadata.readOnly);
        this.file = fileMetadata.file;
        this.fileMode = fileMetadata.fileMode;
        this.raf = fileMetadata.raf;
    }

    @Override
    public ByteBuffer readRootBlock(boolean rootBlock0) {
        if (!this.isOpen()) {
            throw new IllegalStateException();
        }
        ByteBuffer tmp = ByteBuffer.allocate(340);
        try {
            FileChannelUtility.readAll(this.opener, tmp, rootBlock0 ? 8L : 348L);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        tmp.position(0);
        return tmp;
    }

    @Override
    public void writeRootBlock(IRootBlockView rootBlock, ForceEnum forceOnCommit) {
        if (rootBlock == null) {
            throw new IllegalArgumentException();
        }
        try {
            ByteBuffer data = rootBlock.asReadOnlyBuffer();
            long pos = rootBlock.isRootBlock0() ? 8L : 348L;
            FileChannelUtility.writeAll(this.opener, data, pos);
            if (forceOnCommit != ForceEnum.No) {
                this.force(forceOnCommit == ForceEnum.ForceMetadata);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public synchronized long transferTo(RandomAccessFile out) throws IOException {
        return BasicBufferStrategy.transferFromDiskTo(this, out);
    }

    @Override
    public ByteBuffer read(long addr) {
        if (this.isOpen() && !this.raf.getChannel().isOpen()) {
            try {
                this.reopenChannel();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return super.read(addr);
    }

    private final synchronized FileChannel reopenChannel() throws IOException {
        block7: {
            this.assertOpen();
            if (this.raf != null && this.raf.getChannel().isOpen()) {
                return this.raf.getChannel();
            }
            this.raf = new RandomAccessFile(this.file, this.fileMode);
            if (log.isInfoEnabled()) {
                log.info((Object)("(Re-)opened file: " + this.file));
            }
            if (this.bufferMode != BufferMode.Mapped) {
                try {
                    boolean readOnly = "r".equals(this.fileMode);
                    if (this.raf.getChannel().tryLock(0L, Long.MAX_VALUE, readOnly) != null) break block7;
                    try {
                        this.raf.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new IOException("File already locked? file=" + this.file);
                }
                catch (IOException ex) {
                    if (!log.isInfoEnabled()) break block7;
                    log.info((Object)("FileLock not supported: file=" + this.file), (Throwable)ex);
                }
            }
        }
        return this.raf.getChannel();
    }

    public void setNextOffset(long lastOffset) {
    }
}

