/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.io.FileChannelUtility;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.DiskBackedBufferStrategy;
import com.bigdata.journal.FileMetadata;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DirectBufferStrategy
extends DiskBackedBufferStrategy {
    DirectBufferStrategy(long maximumExtent, FileMetadata fileMetadata) {
        super(maximumExtent, BufferMode.Direct, fileMetadata);
    }

    @Override
    public boolean isFullyBuffered() {
        return true;
    }

    @Override
    public long write(ByteBuffer data) {
        long addr = super.write(data);
        long offset = this.getOffset(addr);
        int nbytes = this.getByteCount(addr);
        ByteBuffer buffer = this.getBufferView(false);
        buffer.limit((int)offset + nbytes);
        buffer.position((int)offset);
        try {
            FileChannelUtility.writeAll(this.opener, buffer, (long)this.headerSize + offset);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return addr;
    }

    @Override
    public synchronized void truncate(long newExtent) {
        super.truncate(newExtent);
        try {
            this.getRandomAccessFile().setLength(newExtent);
            this.force(true);
            if (log.isDebugEnabled()) {
                log.info((Object)("Disk file: newLength=" + cf.format(newExtent)));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setNextOffset(long lastOffset) {
    }
}

