/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.journal.Journal;
import com.bigdata.journal.Options;
import java.io.File;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.Future;

public class CompactJournalUtility {
    public static void usage() {
        System.err.println("usage: inFile outFile");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            CompactJournalUtility.usage();
        }
        File inFile = new File(args[0]);
        File outFile = new File(args[1]);
        if (!inFile.exists()) {
            System.err.println("Source file does not exist: " + inFile);
            System.exit(1);
        }
        if (outFile.exists() && outFile.length() > 0L) {
            System.err.println("Output file exists and is not empty: " + outFile);
            System.exit(1);
        }
        System.out.println("inFile=" + inFile + ", outFile=" + outFile);
        Properties p = new Properties();
        p.setProperty(Options.FILE, inFile.getAbsolutePath());
        Journal sourceJournal = new Journal(p);
        System.out.println("source: nbytes=" + sourceJournal.size() + ", nindices=" + sourceJournal.getName2Addr(sourceJournal.getLastCommitTime()).rangeCount());
        try {
            Future<Journal> f = sourceJournal.compact(outFile);
            System.out.println("Running: " + new Date());
            Journal newJournal = f.get();
            System.out.println("Success: " + new Date());
            long bytesBefore = sourceJournal.size();
            long bytesAfter = newJournal.size();
            int percentChange = 100 - (int)((double)bytesAfter * 100.0 / (double)bytesBefore);
            System.out.println("bytes used: before=" + bytesBefore + ", after=" + bytesAfter + ", reducedBy=" + percentChange + "%");
            newJournal.shutdownNow();
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            sourceJournal.shutdownNow();
        }
        sourceJournal.shutdown();
        System.exit(0);
    }
}

