/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.io.ByteBufferInputStream;
import com.bigdata.io.LongPacker;
import com.bigdata.journal.CommitRecord;
import com.bigdata.journal.ICommitRecord;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CommitRecordSerializer {
    public static final int VERSION0 = 0;
    public static final transient CommitRecordSerializer INSTANCE = new CommitRecordSerializer();

    public byte[] serialize(ICommitRecord commitRecord) {
        long timestamp = commitRecord.getTimestamp();
        long commitCounter = commitRecord.getCommitCounter();
        int n = commitRecord.getRootAddrCount();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(n * 8);
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(0);
            dos.writeLong(timestamp);
            dos.writeLong(commitCounter);
            LongPacker.packLong(dos, (long)n);
            for (int i = 0; i < n; ++i) {
                dos.writeLong(commitRecord.getRootAddr(i));
            }
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ICommitRecord deserialize(ByteBuffer buf) {
        try {
            ByteBufferInputStream bbis = new ByteBufferInputStream(buf);
            DataInputStream dis = new DataInputStream(bbis);
            int version = dis.readInt();
            if (version != 0) {
                throw new RuntimeException("Unknown version: " + version);
            }
            long timestamp = dis.readLong();
            long commitCounter = dis.readLong();
            int n = (int)LongPacker.unpackLong(dis);
            long[] roots = new long[n];
            for (int i = 0; i < n; ++i) {
                roots[i] = dis.readLong();
            }
            return new CommitRecord(timestamp, commitCounter, roots);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

