/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io.writecache;

import com.bigdata.counters.CAT;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.io.writecache.IWriteCacheCounters;

public class WriteCacheCounters
implements IWriteCacheCounters {
    public final CAT nhit = new CAT();
    public final CAT nmiss = new CAT();
    public long naccept;
    public long bytesAccepted;
    public long nchannelWrite;
    public long bytesWritten;
    public long elapsedWriteNanos;

    public CounterSet getCounters() {
        CounterSet root = new CounterSet();
        root.addCounter("nhit", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheCounters.this.nhit.get());
            }
        });
        root.addCounter("nmiss", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheCounters.this.nmiss.get());
            }
        });
        root.addCounter("hitRate", new Instrument<Double>(){

            @Override
            public void sample() {
                long nhit = WriteCacheCounters.this.nhit.get();
                long ntests = nhit + WriteCacheCounters.this.nmiss.get();
                this.setValue(ntests == 0L ? 0.0 : (double)nhit / (double)ntests);
            }
        });
        root.addCounter("naccept", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheCounters.this.naccept);
            }
        });
        root.addCounter("bytesAccepted", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheCounters.this.bytesAccepted);
            }
        });
        root.addCounter("nchannelWrite", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheCounters.this.nchannelWrite);
            }
        });
        root.addCounter("bytesWritten", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheCounters.this.bytesWritten);
            }
        });
        root.addCounter("bytesPerWrite", new Instrument<Double>(){

            @Override
            public void sample() {
                double bytesPerWrite = WriteCacheCounters.this.nchannelWrite == 0L ? 0.0 : (double)WriteCacheCounters.this.bytesWritten / (double)WriteCacheCounters.this.nchannelWrite;
                this.setValue(bytesPerWrite);
            }
        });
        root.addCounter("writeSecs", new Instrument<Double>(){

            @Override
            public void sample() {
                this.setValue((double)WriteCacheCounters.this.elapsedWriteNanos / 1.0E9);
            }
        });
        return root;
    }

    public String toString() {
        return this.getCounters().toString();
    }
}

