/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ShortPacker {
    public static int packShort(DataOutput os, short v) throws IOException {
        if (v < 0) {
            throw new IllegalArgumentException("negative value: v=" + v);
        }
        if (v > 127) {
            os.write((byte)(0xFF & v >> 8 | 0x80));
            os.write((byte)(0xFF & v));
            return 2;
        }
        os.write((byte)(0xFF & v));
        return 1;
    }

    public static short unpackShort(DataInput is) throws IOException {
        short v;
        short b = is.readByte();
        if ((b & 0x80) != 0) {
            v = (short)((b & 0x7F) << 8);
            b = is.readByte();
            v = (short)(v | b & 0xFF);
        } else {
            v = b;
        }
        return v;
    }

    public static short unpackShort(InputStream is) throws IOException {
        short v;
        short b = ShortPacker.readByte(is);
        if ((b & 0x80) != 0) {
            v = (short)((b & 0x7F) << 8);
            b = ShortPacker.readByte(is);
            v = (short)(v | b & 0xFF);
        } else {
            v = b;
        }
        return v;
    }

    private static byte readByte(InputStream is) throws IOException {
        int v = is.read();
        if (v == -1) {
            throw new EOFException();
        }
        return (byte)(v & 0xFF);
    }

    public static int getNBytes(byte firstByte) {
        if ((firstByte & 0x80) != 0) {
            return 2;
        }
        return 1;
    }
}

