/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import com.bigdata.io.ByteArrayBuffer;
import it.unimi.dsi.fastutil.io.RepositionableStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DataInputBuffer
extends InputStream
implements DataInput,
RepositionableStream {
    private byte[] buf;
    private int origin;
    private int off;
    private int limit;

    public DataInputBuffer(byte[] buf) {
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        this.buf = buf;
        this.origin = 0;
        this.off = 0;
        this.limit = buf.length;
    }

    public DataInputBuffer(byte[] buf, int off, int len) {
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        assert (off >= 0);
        assert (len >= 0);
        assert (off + len <= buf.length);
        this.buf = buf;
        this.off = this.origin = off;
        this.limit = off + len;
    }

    public DataInputBuffer(ByteArrayBuffer buf) {
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        this.buf = buf.array();
        this.off = this.origin = buf.pos;
        this.limit = buf.limit;
    }

    public void setBuffer(byte[] buf) {
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        this.setBuffer(buf, 0, buf.length);
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public void setBuffer(byte[] buf, int off, int len) {
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        if (off + len > buf.length) {
            throw new IllegalArgumentException();
        }
        this.buf = buf;
        this.off = this.origin = off;
        this.limit = off + len;
    }

    public void setBuffer(ByteArrayBuffer buf) {
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        this.setBuffer(buf.array(), buf.pos, buf.limit);
    }

    public int getOrigin() {
        return this.origin;
    }

    @Override
    public boolean readBoolean() throws IOException {
        if (this.off >= this.limit) {
            throw new EOFException();
        }
        return this.buf[this.off++] != 0;
    }

    @Override
    public int read() throws IOException {
        if (this.off >= this.limit) {
            return -1;
        }
        return 0xFF & this.buf[this.off++];
    }

    @Override
    public byte readByte() throws IOException {
        if (this.off >= this.limit) {
            throw new EOFException();
        }
        return this.buf[this.off++];
    }

    @Override
    public char readChar() throws IOException {
        if (this.off + 2 > this.limit) {
            throw new EOFException();
        }
        byte ch1 = this.buf[this.off++];
        byte ch2 = this.buf[this.off++];
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] a, int aoff, int alen) throws IOException {
        if (this.off + alen > this.limit) {
            throw new EOFException();
        }
        System.arraycopy(this.buf, this.off, a, aoff, alen);
        this.off += alen;
    }

    @Override
    public final int read(byte[] a, int aoff, int alen) throws IOException {
        if (alen == 0) {
            return 0;
        }
        int remaining = this.limit - this.off;
        if (remaining == 0) {
            return -1;
        }
        int n = remaining < alen ? remaining : alen;
        System.arraycopy(this.buf, this.off, a, aoff, n);
        this.off += n;
        return n;
    }

    @Override
    public int readInt() throws IOException {
        if (this.off + 4 > this.limit) {
            throw new EOFException();
        }
        int v = 0;
        v += (0xFF & this.buf[this.off++]) << 24;
        v += (0xFF & this.buf[this.off++]) << 16;
        v += (0xFF & this.buf[this.off++]) << 8;
        return v += (0xFF & this.buf[this.off++]) << 0;
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readLong() throws IOException {
        if (this.off + 8 > this.limit) {
            throw new EOFException();
        }
        long v = 0L;
        v += (0xFFL & (long)this.buf[this.off++]) << 56;
        v += (0xFFL & (long)this.buf[this.off++]) << 48;
        v += (0xFFL & (long)this.buf[this.off++]) << 40;
        v += (0xFFL & (long)this.buf[this.off++]) << 32;
        v += (0xFFL & (long)this.buf[this.off++]) << 24;
        v += (0xFFL & (long)this.buf[this.off++]) << 16;
        v += (0xFFL & (long)this.buf[this.off++]) << 8;
        return v += (0xFFL & (long)this.buf[this.off++]) << 0;
    }

    @Override
    public short readShort() throws IOException {
        if (this.off + 2 > this.limit) {
            throw new EOFException();
        }
        byte ch1 = this.buf[this.off++];
        byte ch2 = this.buf[this.off++];
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public String readUTF2() {
        try {
            return DataInputStream.readUTF(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.off >= this.limit) {
            throw new EOFException();
        }
        return this.buf[this.off++];
    }

    @Override
    public int readUnsignedShort() throws IOException {
        if (this.off + 2 > this.limit) {
            throw new EOFException();
        }
        byte a = this.buf[this.off++];
        byte b = this.buf[this.off++];
        return (a & 0xFF) << 8 | b & 0xFF;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.off += n;
        if (this.off > this.limit) {
            throw new IOException();
        }
        return n;
    }

    public final int unpackInt() throws IOException {
        long v = this.unpackLong();
        if (v > Integer.MAX_VALUE) {
            throw new IOException();
        }
        return (int)v;
    }

    public final long unpackLong() throws IOException {
        long l;
        int nbytes;
        byte b;
        if (this.off + 1 > this.limit) {
            throw new EOFException();
        }
        if (((b = this.buf[this.off++]) & 0x80) != 0) {
            nbytes = 8;
            l = b & 0x7F;
        } else {
            nbytes = b >> 4;
            l = b & 0xF;
        }
        if (this.off + nbytes - 1 > this.limit) {
            throw new EOFException();
        }
        for (int i = 1; i < nbytes; ++i) {
            b = this.buf[this.off++];
            l = (l << 8) + (long)(0xFF & b);
        }
        return l;
    }

    public final short unpackShort() throws IOException {
        short v;
        short b;
        if (this.off + 1 > this.limit) {
            throw new EOFException();
        }
        if (((b = (short)this.buf[this.off++]) & 0x80) != 0) {
            v = (short)((b & 0x7F) << 8);
            if (this.off + 1 > this.limit) {
                throw new EOFException();
            }
            b = this.buf[this.off++];
            v = (short)(v | b & 0xFF);
        } else {
            v = b;
        }
        return v;
    }

    public long position() throws IOException {
        return this.off - this.origin;
    }

    public void position(long v) throws IOException {
        this.off = this.origin + (int)Math.min(v, (long)this.limit);
    }
}

