/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree;

import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.htree.AbstractHTree;
import com.bigdata.htree.BucketPage;
import com.bigdata.htree.Tuple;
import java.util.Iterator;
import java.util.NoSuchElementException;

class BucketPageTupleIterator<E>
implements ITupleIterator<E> {
    private final Iterator<BucketPage> src;
    private BucketPage currentBucketPage = null;
    private int nextNonEmptySlot = 0;
    private final Tuple<E> tuple;

    BucketPageTupleIterator(AbstractHTree htree, int flags, Iterator<BucketPage> src) {
        if (htree == null) {
            throw new IllegalArgumentException();
        }
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.tuple = new Tuple(htree, flags);
        this.src = src;
    }

    private boolean findNextSlot() {
        if (this.currentBucketPage == null) {
            throw new IllegalStateException();
        }
        IRaba keys = this.currentBucketPage.getKeys();
        int size = keys.size();
        while (this.nextNonEmptySlot < size) {
            if (!keys.isNull(this.nextNonEmptySlot)) {
                return true;
            }
            ++this.nextNonEmptySlot;
        }
        this.currentBucketPage = null;
        return false;
    }

    @Override
    public boolean hasNext() {
        if (this.currentBucketPage != null) {
            return true;
        }
        while (this.src.hasNext()) {
            this.currentBucketPage = this.src.next();
            this.nextNonEmptySlot = 0;
            if (!this.findNextSlot()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ITuple<E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.tuple.copy(this.nextNonEmptySlot, this.currentBucketPage);
        ++this.nextNonEmptySlot;
        this.findNextSlot();
        return this.tuple;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

