/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.render;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounter;
import com.bigdata.counters.query.ICounterSelector;
import com.bigdata.counters.query.URLQueryModel;
import com.bigdata.counters.render.IRenderer;
import java.io.IOException;
import java.io.Writer;

public class XMLRenderer
implements IRenderer {
    private final URLQueryModel model;
    private final ICounterSelector counterSelector;
    private final String charset;

    public XMLRenderer(URLQueryModel model, ICounterSelector counterSelector, String charset) {
        if (model == null) {
            throw new IllegalArgumentException();
        }
        if (counterSelector == null) {
            throw new IllegalArgumentException();
        }
        if (charset == null) {
            throw new IllegalArgumentException();
        }
        this.model = model;
        this.counterSelector = counterSelector;
        this.charset = charset;
    }

    @Override
    public void render(Writer w) {
        CounterSet counterSet = new CounterSet();
        ICounter[] counters = this.counterSelector.selectCounters(this.model.depth, this.model.pattern, this.model.fromTime, this.model.toTime, this.model.period, false);
        String pathPrefix = this.model.path != null && this.model.path.length() > 0 ? this.model.path : null;
        for (ICounter counter : counters) {
            if (pathPrefix != null && !counter.getPath().startsWith(pathPrefix)) continue;
            counterSet.makePath(counter.getParent().getPath()).attach(counter);
        }
        try {
            counterSet.asXML(w, this.charset, null);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

