/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.system.SystemUtil;

public class KernelVersion {
    private static final Logger log = Logger.getLogger(KernelVersion.class);
    public final int version;
    public final int major;
    public final int minor;
    private static Pattern p = Pattern.compile("^([0-9]+).([0-9]+).([0-9]+).*");

    public KernelVersion(String val) {
        if (val == null) {
            throw new IllegalArgumentException();
        }
        Matcher m = p.matcher(val);
        if (!m.matches()) {
            throw new IllegalArgumentException("Not a kernel version? [" + val + "]");
        }
        this.version = Integer.parseInt(m.group(1));
        this.major = Integer.parseInt(m.group(2));
        this.minor = Integer.parseInt(m.group(3));
    }

    public String toString() {
        return "{version=" + this.version + ", major=" + this.major + ", minor=" + this.minor + "}";
    }

    public static KernelVersion get() {
        Process pr;
        LinkedList<String> commands = new LinkedList<String>();
        try {
            if (SystemUtil.isLinux()) {
                commands.add("/bin/uname");
            } else if (SystemUtil.isOSX()) {
                commands.add("/usr/bin/uname");
            } else {
                commands.add("/bin/uname");
            }
            commands.add("-r");
            ProcessBuilder pb = new ProcessBuilder(commands);
            pr = pb.start();
            pr.waitFor();
        }
        catch (Exception ex) {
            throw new RuntimeException("Problem running command: [" + commands + "]", ex);
        }
        if (pr.exitValue() == 0) {
            String val;
            BufferedReader outReader = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            try {
                val = outReader.readLine();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                try {
                    outReader.close();
                }
                catch (IOException ex) {
                    log.error((Object)ex, (Throwable)ex);
                }
            }
            if (val == null) {
                throw new RuntimeException("Nothing returned.");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("read: [" + val + "]"));
            }
            return new KernelVersion(val.trim());
        }
        throw new RuntimeException("Could not get kernal version: exitValue=" + pr.exitValue());
    }

    public static void main(String[] args) {
        KernelVersion kver = KernelVersion.get();
        System.out.println("kernel version: " + kver);
    }
}

