/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.data.INodeData;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.MutableKeyBuffer;
import com.bigdata.io.AbstractFixedByteArrayBuffer;

public class MutableNodeData
implements INodeData {
    final MutableKeyBuffer keys;
    final long[] childAddr;
    long nentries;
    final long[] childEntryCounts;
    final boolean hasVersionTimestamps;
    long minimumVersionTimestamp;
    long maximumVersionTimestamp;

    public MutableNodeData(int branchingFactor, boolean hasVersionTimestamps) {
        this.nentries = 0L;
        this.keys = new MutableKeyBuffer(branchingFactor);
        this.childAddr = new long[branchingFactor + 1];
        this.childEntryCounts = new long[branchingFactor + 1];
        this.hasVersionTimestamps = hasVersionTimestamps;
        this.maximumVersionTimestamp = 0L;
        this.minimumVersionTimestamp = 0L;
    }

    public MutableNodeData(int branchingFactor, INodeData src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.keys = new MutableKeyBuffer(branchingFactor, src.getKeys());
        this.nentries = src.getSpannedTupleCount();
        if (this.nentries <= 0L) {
            throw new RuntimeException();
        }
        this.childAddr = new long[branchingFactor + 1];
        this.childEntryCounts = new long[branchingFactor + 1];
        int nkeys = this.keys.size();
        long sum = 0L;
        for (int i = 0; i <= nkeys; ++i) {
            this.childAddr[i] = src.getChildAddr(i);
            this.childEntryCounts[i] = src.getChildEntryCount(i);
            long tmp = this.childEntryCounts[i];
            if (tmp <= 0L) {
                throw new RuntimeException();
            }
            sum += tmp;
        }
        this.hasVersionTimestamps = src.hasVersionTimestamps();
        if (src.hasVersionTimestamps()) {
            this.minimumVersionTimestamp = src.getMinimumVersionTimestamp();
            this.maximumVersionTimestamp = src.getMaximumVersionTimestamp();
        }
        if (sum != this.nentries) {
            throw new RuntimeException();
        }
    }

    public MutableNodeData(long nentries, IRaba keys, long[] childAddr, long[] childEntryCounts, boolean hasVersionTimestamps, long minimumVersionTimestamp, long maximumVersionTimestamp) {
        assert (keys != null);
        assert (childAddr != null);
        assert (childEntryCounts != null);
        assert (keys.capacity() + 1 == childAddr.length);
        assert (childAddr.length == childEntryCounts.length);
        this.nentries = nentries;
        this.keys = (MutableKeyBuffer)keys;
        this.childAddr = childAddr;
        this.childEntryCounts = childEntryCounts;
        this.hasVersionTimestamps = hasVersionTimestamps;
        this.minimumVersionTimestamp = minimumVersionTimestamp;
        this.maximumVersionTimestamp = maximumVersionTimestamp;
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    @Override
    public final boolean isCoded() {
        return false;
    }

    @Override
    public final AbstractFixedByteArrayBuffer data() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long getSpannedTupleCount() {
        return this.nentries;
    }

    protected final boolean rangeCheckChildIndex(int index) {
        if (index < 0 || index > this.getKeys().size() + 1) {
            throw new IndexOutOfBoundsException();
        }
        return true;
    }

    @Override
    public final long getChildAddr(int index) {
        assert (this.rangeCheckChildIndex(index));
        return this.childAddr[index];
    }

    @Override
    public final long getChildEntryCount(int index) {
        assert (this.rangeCheckChildIndex(index));
        return this.childEntryCounts[index];
    }

    @Override
    public final int getChildCount() {
        return this.getKeys().size() + 1;
    }

    @Override
    public final int getKeyCount() {
        return this.keys.size();
    }

    @Override
    public final IRaba getKeys() {
        return this.keys;
    }

    @Override
    public final boolean isLeaf() {
        return false;
    }

    @Override
    public final boolean hasVersionTimestamps() {
        return this.hasVersionTimestamps;
    }

    @Override
    public final long getMaximumVersionTimestamp() {
        if (!this.hasVersionTimestamps) {
            throw new UnsupportedOperationException();
        }
        return this.maximumVersionTimestamp;
    }

    @Override
    public final long getMinimumVersionTimestamp() {
        if (!this.hasVersionTimestamps) {
            throw new UnsupportedOperationException();
        }
        return this.minimumVersionTimestamp;
    }
}

