/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

public enum IndexSegmentRegion {
    BASE(0),
    NODE(1),
    BLOB(2);

    private final int code;
    protected static final long NBITS = 2L;
    private static final long MASK = 3L;

    private IndexSegmentRegion(int code) {
        this.code = code;
    }

    public int code() {
        return this.code;
    }

    public long encodeOffset(long offset) {
        return offset << 2 | (long)this.code;
    }

    public static IndexSegmentRegion decodeRegion(long encodedOffset) {
        int code = (int)(3L & encodedOffset);
        switch (code) {
            case 0: {
                return BASE;
            }
            case 1: {
                return NODE;
            }
            case 2: {
                return BLOB;
            }
        }
        throw new IllegalArgumentException();
    }

    public static long decodeOffset(long encodedOffset) {
        return encodedOffset >>> 2;
    }
}

