/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.ICheckpoint;
import com.bigdata.btree.IndexSegmentAddressManager;
import com.bigdata.btree.IndexTypeEnum;
import com.bigdata.io.ChecksumUtility;
import com.bigdata.io.FileChannelUtility;
import com.bigdata.io.NOPReopener;
import com.bigdata.journal.RootBlockException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;
import org.apache.log4j.Logger;

public class IndexSegmentCheckpoint
implements ICheckpoint {
    private static final Logger log = Logger.getLogger(IndexSegmentCheckpoint.class);
    private static final String ERR_EMPTY = "Empty file";
    private static final String ERR_TOO_SMALL = "Too small for valid root block";
    private static final int SIZEOF_MAGIC = 4;
    private static final int SIZEOF_VERSION = 4;
    private static final int SIZEOF_OFFSET_BITS = 4;
    private static final int SIZEOF_BRANCHING_FACTOR = 4;
    private static final int SIZEOF_COUNTS = 4;
    private static final int SIZEOF_NBYTES = 4;
    private static final int SIZEOF_ADDR = 8;
    private static final int SIZEOF_ERROR_RATE = 8;
    private static final int SIZEOF_TIMESTAMP = 8;
    private static final int SIZEOF_CHECKSUM = 4;
    static final int SIZEOF_UNUSED_VERSION0 = 256;
    static final int SIZEOF_UNUSED_VERSION1 = 255;
    static final int SIZEOF_UNUSED_VERSION2 = 247;
    static final int SIZE = 421;
    public static final transient int MAGIC = -2018822923;
    public static final transient int VERSION0 = 0;
    public static final transient int VERSION1 = 1;
    public static final transient int VERSION2 = 2;
    public static final transient int currentVersion = 2;
    public final UUID segmentUUID;
    public final int offsetBits;
    final IndexSegmentAddressManager am;
    public final int height;
    public final int nleaves;
    public final int nnodes;
    public final long nentries;
    public final int maxNodeOrLeafLength;
    public final long offsetLeaves;
    public final long extentLeaves;
    public final long offsetNodes;
    public final long extentNodes;
    public final long offsetBlobs;
    public final long extentBlobs;
    public final long addrRoot;
    public final long addrMetadata;
    public final long addrBloom;
    public final long addrFirstLeaf;
    public final long addrLastLeaf;
    public final long length;
    public final boolean compactingMerge;
    public final boolean useChecksums;
    public final long commitTime;
    private int checksum;
    private final ByteBuffer buf;

    public IndexSegmentCheckpoint(RandomAccessFile raf) throws IOException {
        if (raf == null) {
            throw new IllegalArgumentException();
        }
        long len = raf.length();
        if (len == 0L) {
            throw new RootBlockException(ERR_EMPTY);
        }
        if (raf.length() < 421L) {
            throw new RootBlockException(ERR_TOO_SMALL);
        }
        ByteBuffer buf = ByteBuffer.allocate(421);
        FileChannelUtility.readAll(new NOPReopener(raf), buf, 0L);
        buf.rewind();
        int magic = buf.getInt();
        if (magic != -2018822923) {
            throw new RootBlockException("MAGIC: expected=-2018822923, actual=" + magic);
        }
        int version = buf.getInt();
        if (version < 0 || version > 2) {
            throw new RootBlockException("unknown version=" + version);
        }
        long timestamp0 = buf.getLong();
        this.segmentUUID = new UUID(buf.getLong(), buf.getLong());
        this.offsetBits = buf.getInt();
        this.height = buf.getInt();
        this.nleaves = buf.getInt();
        this.nnodes = buf.getInt();
        long nentries = -1L;
        if (version < 2) {
            nentries = buf.getInt();
        } else {
            buf.getInt();
        }
        this.maxNodeOrLeafLength = buf.getInt();
        this.offsetLeaves = buf.getLong();
        this.extentLeaves = buf.getLong();
        this.offsetNodes = buf.getLong();
        this.extentNodes = buf.getLong();
        this.offsetBlobs = buf.getLong();
        this.extentBlobs = buf.getLong();
        this.addrRoot = buf.getLong();
        this.addrMetadata = buf.getLong();
        this.addrBloom = buf.getLong();
        this.addrFirstLeaf = buf.getLong();
        this.addrLastLeaf = buf.getLong();
        this.length = buf.getLong();
        boolean bl = this.compactingMerge = buf.get() != 0;
        this.useChecksums = version >= 1 ? buf.get() != 0 : false;
        if (version >= 2) {
            nentries = buf.getLong();
        }
        this.nentries = nentries;
        switch (version) {
            case 0: {
                buf.position(buf.position() + 256);
                break;
            }
            case 1: {
                buf.position(buf.position() + 255);
                break;
            }
            case 2: {
                buf.position(buf.position() + 247);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.checksum = buf.getInt();
        long timestamp1 = buf.getLong();
        this.commitTime = timestamp0;
        int checksum = new ChecksumUtility().checksum(buf, 0, 409);
        if (checksum != this.checksum) {
            throw new RootBlockException("Bad checksum: expected=" + this.checksum + ", but actual=" + checksum);
        }
        if (timestamp0 != timestamp1) {
            throw new RootBlockException("Timestamps differ: " + timestamp0 + " vs " + timestamp1);
        }
        if (this.length != raf.length()) {
            throw new RootBlockException("Length differs: actual=" + raf.length() + ", expected=" + this.length);
        }
        this.am = new IndexSegmentAddressManager(this);
        this.validate();
        buf.rewind();
        this.buf = buf.asReadOnlyBuffer();
        if (log.isInfoEnabled()) {
            log.info((Object)this.toString());
        }
    }

    public IndexSegmentCheckpoint(int offsetBits, int height, int nleaves, int nnodes, long nentries, int maxNodeOrLeafLength, long offsetLeaves, long extentLeaves, long offsetNodes, long extentNodes, long offsetBlobs, long extentBlobs, long addrRoot, long addrMetadata, long addrBloom, long addrFirstLeaf, long addrLastLeaf, long length, boolean compactingMerge, boolean useChecksums, UUID segmentUUID, long commitTime) {
        this.segmentUUID = segmentUUID;
        this.offsetBits = offsetBits;
        this.height = height;
        this.nleaves = nleaves;
        this.nnodes = nnodes;
        this.nentries = nentries;
        this.maxNodeOrLeafLength = maxNodeOrLeafLength;
        this.offsetLeaves = offsetLeaves;
        this.extentLeaves = extentLeaves;
        this.offsetNodes = offsetNodes;
        this.extentNodes = extentNodes;
        this.offsetBlobs = offsetBlobs;
        this.extentBlobs = extentBlobs;
        this.addrRoot = addrRoot;
        this.addrMetadata = addrMetadata;
        this.addrBloom = addrBloom;
        this.addrFirstLeaf = addrFirstLeaf;
        this.addrLastLeaf = addrLastLeaf;
        this.length = length;
        this.compactingMerge = compactingMerge;
        this.useChecksums = useChecksums;
        this.commitTime = commitTime;
        this.am = new IndexSegmentAddressManager(this);
        this.validate();
        this.buf = this.createView();
        if (log.isInfoEnabled()) {
            log.info((Object)this.toString());
        }
    }

    public void validate() {
        if (this.height < 0) {
            throw new RootBlockException("height=" + this.height);
        }
        if (this.nentries < 0L) {
            throw new RootBlockException("nentries=" + this.nentries);
        }
        if (this.nleaves <= 0) {
            throw new RootBlockException("nleaves=" + this.nleaves);
        }
        if (this.nnodes < 0) {
            throw new RootBlockException("nnodes=" + this.nnodes);
        }
        if (this.maxNodeOrLeafLength <= 0) {
            throw new RootBlockException("maxNodeOrLeafLength=" + this.maxNodeOrLeafLength);
        }
        if (this.extentLeaves == 0L) {
            throw new RootBlockException("extentLeaves=" + this.extentLeaves);
        }
        if (this.offsetLeaves != 421L) {
            throw new RootBlockException("offsetLeaves=" + this.offsetLeaves + ", but expecting " + 421);
        }
        if (this.offsetLeaves + this.extentLeaves > this.length) {
            throw new RootBlockException("The leaves region extends beyond the end of the file: leaves={extent=" + this.extentLeaves + ", offset=" + this.offsetLeaves + "}, but length=" + this.length);
        }
        if (this.addrFirstLeaf == 0L) {
            throw new RootBlockException("No address for the first leaf?");
        }
        if (this.addrLastLeaf == 0L) {
            throw new RootBlockException("No address for the first leaf?");
        }
        if (this.nnodes == 0) {
            if (this.offsetNodes != 0L || this.extentNodes != 0L) {
                throw new RootBlockException("nodes={extent=" + this.extentNodes + ", offset=" + this.offsetNodes + "}, but expecting zero.");
            }
            if ((long)this.am.getByteCount(this.addrRoot) != this.extentLeaves) {
                throw new RootBlockException("addrRoot(" + this.am.toString(this.addrRoot) + ") : size is not equal to extentLeaves(" + this.extentLeaves + ")");
            }
        } else {
            if (this.offsetNodes == 0L || this.extentNodes == 0L) {
                throw new RootBlockException("nodes={extent=" + this.extentNodes + ", offset=" + this.offsetNodes + "}");
            }
            if (this.offsetNodes + this.extentNodes > this.length) {
                throw new RootBlockException("The nodes region extends beyond the end of the file: nodes={extent=" + this.extentNodes + ",offset=" + this.offsetNodes + "}, but length=" + this.length);
            }
            if (this.am.getOffset(this.addrRoot) + (long)this.am.getByteCount(this.addrRoot) > this.length) {
                throw new RootBlockException("The root node record extends beyond the end of the file: addrRoot=" + this.am.toString(this.addrRoot) + ", but length=" + this.length);
            }
        }
        if (this.commitTime <= 0L) {
            throw new RootBlockException("commitTime=" + this.commitTime);
        }
        if (this.segmentUUID == null) {
            throw new RootBlockException("No segment UUID");
        }
    }

    public ByteBuffer asReadOnlyBuffer() {
        return this.buf.asReadOnlyBuffer();
    }

    private ByteBuffer createView() {
        ByteBuffer buf = ByteBuffer.allocate(421);
        buf.putInt(-2018822923);
        buf.putInt(2);
        buf.putLong(this.commitTime);
        buf.putLong(this.segmentUUID.getMostSignificantBits());
        buf.putLong(this.segmentUUID.getLeastSignificantBits());
        buf.putInt(this.offsetBits);
        buf.putInt(this.height);
        buf.putInt(this.nleaves);
        buf.putInt(this.nnodes);
        buf.putInt(0);
        buf.putInt(this.maxNodeOrLeafLength);
        buf.putLong(this.offsetLeaves);
        buf.putLong(this.extentLeaves);
        buf.putLong(this.offsetNodes);
        buf.putLong(this.extentNodes);
        buf.putLong(this.offsetBlobs);
        buf.putLong(this.extentBlobs);
        buf.putLong(this.addrRoot);
        buf.putLong(this.addrMetadata);
        buf.putLong(this.addrBloom);
        buf.putLong(this.addrFirstLeaf);
        buf.putLong(this.addrLastLeaf);
        buf.putLong(this.length);
        buf.put((byte)(this.compactingMerge ? 1 : 0));
        buf.put((byte)(this.useChecksums ? 1 : 0));
        buf.putLong(this.nentries);
        switch (2) {
            case 0: {
                buf.position(buf.position() + 256);
                break;
            }
            case 1: {
                buf.position(buf.position() + 255);
                break;
            }
            case 2: {
                buf.position(buf.position() + 247);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.checksum = new ChecksumUtility().checksum(buf, 0, 409);
        buf.putInt(this.checksum);
        buf.putLong(this.commitTime);
        assert (buf.position() == 421) : "position=" + buf.position() + " but checkpoint record should be " + 421 + " bytes";
        assert (buf.limit() == 421);
        buf.rewind();
        return buf.asReadOnlyBuffer();
    }

    public void write(RandomAccessFile raf) throws IOException {
        FileChannelUtility.writeAll(raf.getChannel(), this.asReadOnlyBuffer(), 0L);
        if (log.isInfoEnabled()) {
            log.info((Object)("wrote checkpoint record: " + this));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("magic=" + Integer.toHexString(-2018822923));
        sb.append(", segmentUUID=" + this.segmentUUID);
        sb.append(", offsetBits=" + this.offsetBits);
        sb.append(", height=" + this.height);
        sb.append(", nleaves=" + this.nleaves);
        sb.append(", nnodes=" + this.nnodes);
        sb.append(", nentries=" + this.nentries);
        sb.append(", maxNodeOrLeafLength=" + this.maxNodeOrLeafLength);
        sb.append(", leavesRegion={extent=" + this.extentLeaves + ", offset=" + this.offsetLeaves + "}, avgLeafSize=" + (this.nleaves == 0 ? 0L : this.extentLeaves / (long)this.nleaves));
        sb.append(", nodesRegion={extent=" + this.extentNodes + ", offset=" + this.offsetNodes + "}, avgNodeSize=" + (this.nnodes == 0 ? 0L : this.extentNodes / (long)this.nnodes));
        sb.append(", blobsRegion={extent=" + this.extentBlobs + ", offset=" + this.offsetBlobs + "}");
        sb.append(", addrRoot=" + this.am.toString(this.addrRoot));
        sb.append(", addrFirstLeaf=" + this.am.toString(this.addrFirstLeaf));
        sb.append(", addrLastLeaf=" + this.am.toString(this.addrLastLeaf));
        sb.append(", addrMetadata=" + this.am.toString(this.addrMetadata));
        sb.append(", addrBloom=" + this.am.toString(this.addrBloom));
        sb.append(", length=" + this.length);
        sb.append(", compactingMerge=" + this.compactingMerge);
        sb.append(", useChecksums=" + this.useChecksums);
        sb.append(", checksum=" + this.checksum);
        sb.append(", commitTime=" + new Date(this.commitTime));
        return sb.toString();
    }

    @Override
    public long getCheckpointAddr() {
        return 0L;
    }

    @Override
    public boolean hasCheckpointAddr() {
        return false;
    }

    @Override
    public long getMetadataAddr() {
        return this.addrMetadata;
    }

    @Override
    public long getRootAddr() {
        return this.addrRoot;
    }

    @Override
    public long getBloomFilterAddr() {
        return this.addrBloom;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getGlobalDepth() {
        return 0;
    }

    @Override
    public long getNodeCount() {
        return this.nnodes;
    }

    @Override
    public long getLeafCount() {
        return this.nleaves;
    }

    @Override
    public long getEntryCount() {
        return this.nentries;
    }

    @Override
    public long getCounter() {
        return 0L;
    }

    @Override
    public long getRecordVersion() {
        return 0L;
    }

    @Override
    public IndexTypeEnum getIndexType() {
        return IndexTypeEnum.BTree;
    }
}

