/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.solutions;

import com.bigdata.bop.IBind;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.solutions.ISortOrder;
import java.util.Comparator;

public class BindingSetComparator<E>
implements Comparator<IBindingSet> {
    private final ISortOrder<E>[] sortOrder;
    private final Comparator<E> valueComparator;
    private long n = 0L;

    public BindingSetComparator(ISortOrder<E>[] sortOrder, Comparator<E> valueComparator) {
        if (sortOrder == null) {
            throw new IllegalArgumentException();
        }
        if (sortOrder.length == 0) {
            throw new IllegalArgumentException();
        }
        if (valueComparator == null) {
            throw new IllegalArgumentException();
        }
        this.sortOrder = sortOrder;
        this.valueComparator = valueComparator;
    }

    @Override
    public int compare(IBindingSet bs1, IBindingSet bs2) {
        if (this.n++ % 1000L == 1L && Thread.interrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
        for (int i = 0; i < this.sortOrder.length; ++i) {
            ISortOrder<E> o = this.sortOrder[i];
            IValueExpression<E> v = o.getExpr();
            if (v instanceof IBind) {
                v = ((IBind)v).getVar();
            }
            int ret = this.valueComparator.compare(v.get(bs1), v.get(bs2));
            if (!o.isAscending()) {
                ret = -ret;
            }
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }
}

