/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

public class ChunkedMaterializationOp
extends PipelineOp {
    private static final Logger log = Logger.getLogger(ChunkedMaterializationOp.class);
    private static final long serialVersionUID = 1L;

    public ChunkedMaterializationOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        IVariable<?>[] vars = this.getVars();
        if (vars != null && vars.length == 0) {
            throw new IllegalArgumentException();
        }
        this.getRequiredProperty(Annotations.RELATION_NAME);
        this.getRequiredProperty(Annotations.TIMESTAMP);
    }

    public ChunkedMaterializationOp(ChunkedMaterializationOp op) {
        super(op);
    }

    public ChunkedMaterializationOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    public ChunkedMaterializationOp(BOp[] args, IVariable<?>[] vars, String namespace, long timestamp) {
        this(args, new NV(Annotations.VARS, vars), new NV(Annotations.RELATION_NAME, new String[]{namespace}), new NV(Annotations.TIMESTAMP, timestamp));
    }

    public IVariable<?>[] getVars() {
        return (IVariable[])this.getProperty(Annotations.VARS);
    }

    public boolean materializeInlineIVs() {
        return this.getProperty(Annotations.MATERIALIZE_INLINE_IVS, false);
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(this, context));
    }

    static IBindingSet[] resolveChunk(IVariable<?>[] required, LexiconRelation lex, IBindingSet[] chunkIn, boolean materializeInlineIVs) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Fetched chunk: size=" + chunkIn.length + ", chunk=" + Arrays.toString(chunkIn)));
        }
        int initialCapacity = required == null ? chunkIn.length : (required.length == 0 ? 1 : chunkIn.length * required.length);
        HashMap idToConstMap = new HashMap(initialCapacity);
        IBindingSet[] arr$ = chunkIn;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            IBindingSet solution;
            IBindingSet bindingSet = solution = arr$[i$];
            assert (bindingSet != null);
            if (required == null) {
                for (Map.Entry entry : bindingSet) {
                    IV iv = (IV)((IConstant)entry.getValue()).get();
                    if (iv == null) {
                        throw new RuntimeException("NULL? : var=" + entry.getKey() + ", " + bindingSet);
                    }
                    if (!iv.needsMaterialization() && !materializeInlineIVs || idToConstMap.containsKey(iv)) continue;
                    idToConstMap.put(iv, (IConstant<?>)entry.getValue());
                }
                continue;
            }
            for (IVariable<?> v : required) {
                IConstant c = bindingSet.get(v);
                if (c == null) continue;
                IV iv = (IV)c.get();
                if (iv == null) {
                    throw new RuntimeException("NULL? : var=" + v + ", " + bindingSet);
                }
                if (!iv.needsMaterialization() && !materializeInlineIVs || idToConstMap.containsKey(iv)) continue;
                idToConstMap.put(iv, c);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Resolving " + idToConstMap.keySet().size() + " IVs, required=" + Arrays.toString(required)));
        }
        Map<IV<?, ?>, BigdataValue> terms = lex.getTerms(idToConstMap.keySet());
        IBindingSet[] chunkOut = new IBindingSet[chunkIn.length];
        for (int i = 0; i < chunkIn.length; ++i) {
            chunkOut[i] = ChunkedMaterializationOp.getBindingSet(required, chunkIn[i], terms, idToConstMap);
        }
        return chunkOut;
    }

    private static IBindingSet getBindingSet(IVariable<?>[] required, IBindingSet bindingSetIn, Map<IV<?, ?>, BigdataValue> terms, Map<IV<?, ?>, IConstant<?>> idsToConstMap) {
        if (bindingSetIn == null) {
            throw new IllegalArgumentException();
        }
        if (terms == null) {
            throw new IllegalArgumentException();
        }
        if (idsToConstMap == null) {
            throw new IllegalArgumentException();
        }
        IBindingSet bindingSetOut = bindingSetIn.clone();
        if (required != null) {
            for (IVariable<?> var : required) {
                IV iv;
                IConstant c = bindingSetOut.get(var);
                if (c == null || (iv = (IV)c.get()) == null) continue;
                if (iv.isInline()) {
                    IConstant<?> cVal = idsToConstMap.get(iv);
                    if (cVal == null) {
                        if (!iv.needsMaterialization()) continue;
                        throw new RuntimeException("Could not resolve: iv=" + iv);
                    }
                    bindingSetOut.set(var, cVal);
                    continue;
                }
                BigdataValue value = terms.get(iv);
                ChunkedMaterializationOp.conditionallySetIVCache(iv, value);
            }
        } else {
            for (Map.Entry entry : bindingSetOut) {
                Object boundValue = ((IConstant)entry.getValue()).get();
                if (!(boundValue instanceof IV)) continue;
                IV iv = (IV)boundValue;
                BigdataValue value = terms.get(iv);
                if (iv.isInline()) {
                    IConstant<?> cVal = idsToConstMap.get(iv);
                    if (cVal == null) {
                        if (!iv.needsMaterialization()) continue;
                        throw new RuntimeException("Could not resolve: iv=" + iv);
                    }
                    bindingSetOut.set((IVariable)entry.getKey(), idsToConstMap.get(iv));
                    continue;
                }
                ChunkedMaterializationOp.conditionallySetIVCache(iv, value);
            }
        }
        return bindingSetOut;
    }

    private static void conditionallySetIVCache(IV<?, ?> iv, BigdataValue value) {
        if (value == null) {
            if (iv.needsMaterialization()) {
                throw new RuntimeException("Could not resolve: iv=" + iv);
            }
        } else {
            iv.setValue(value);
        }
    }

    private static class ChunkTask
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final IVariable<?>[] vars;
        private final String namespace;
        private final long timestamp;
        private final boolean materializeInlineIVs;

        ChunkTask(ChunkedMaterializationOp op, BOpContext<IBindingSet> context) {
            this.context = context;
            this.vars = op.getVars();
            this.namespace = ((String[])op.getProperty(Annotations.RELATION_NAME))[0];
            this.timestamp = (Long)op.getProperty(Annotations.TIMESTAMP);
            this.materializeInlineIVs = op.materializeInlineIVs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            BOpStats stats = this.context.getStats();
            ICloseableIterator<IBindingSet[]> itr = this.context.getSource();
            try (IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();){
                LexiconRelation lex = (LexiconRelation)this.context.getResource(this.namespace, this.timestamp);
                while (itr.hasNext()) {
                    IBindingSet[] a = (IBindingSet[])itr.next();
                    stats.chunksIn.increment();
                    stats.unitsIn.add(a.length);
                    IBindingSet[] aOut = ChunkedMaterializationOp.resolveChunk(this.vars, lex, a, this.materializeInlineIVs);
                    sink.add(aOut);
                }
                sink.flush();
                Void void_ = null;
                return void_;
            }
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations {
        public static final String VARS = ChunkedMaterializationOp.class.getName() + ".vars";
        public static final String RELATION_NAME = Predicate.Annotations.RELATION_NAME;
        public static final String TIMESTAMP = Predicate.Annotations.TIMESTAMP;
        public static final String MATERIALIZE_INLINE_IVS = ChunkedMaterializationOp.class.getName() + ".materializeAll";
        public static final boolean DEFAULT_MATERIALIZE_INLINE_IVS = false;
    }
}

