/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.filter;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BTreeAnnotations;
import com.bigdata.bop.HTreeAnnotations;
import com.bigdata.bop.HashMapAnnotations;
import com.bigdata.bop.ap.filter.BOpFilterBase;
import com.bigdata.btree.BTree;
import com.bigdata.btree.BloomFilterFactory;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.HTreeIndexMetadata;
import com.bigdata.btree.ICheckpointProtocol;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.raba.codec.EmptyRabaValueCoder;
import com.bigdata.btree.raba.codec.FrontCodedRabaCoder;
import com.bigdata.htree.HTree;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rwstore.sector.MemStore;
import com.bigdata.rwstore.sector.MemoryManager;
import com.bigdata.util.BytesUtil;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.Filterator;
import cutthecrap.utils.striterators.ICloseable;
import cutthecrap.utils.striterators.IPropertySet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class NativeDistinctFilter
extends BOpFilterBase {
    private static final long serialVersionUID = 1L;

    public static NativeDistinctFilter newInstance(SPOKeyOrder indexKeyOrder) {
        return new NativeDistinctFilter(BOp.NOARGS, Collections.singletonMap("keyOrder", indexKeyOrder));
    }

    public NativeDistinctFilter(NativeDistinctFilter op) {
        super(op);
    }

    public NativeDistinctFilter(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        this.getRequiredProperty("keyOrder");
    }

    @Override
    protected final Iterator filterOnce(Iterator src, Object context) {
        return new Filterator(src, context, (Filter)new DistinctFilterImpl((IPropertySet)this));
    }

    public static int[] getFilterKeyOrder(SPOKeyOrder indexKeyOrder) {
        int[] filterKeyOrder;
        if (indexKeyOrder == null) {
            throw new IllegalArgumentException();
        }
        switch (indexKeyOrder.index()) {
            case 0: {
                filterKeyOrder = new int[]{0, 1, 2};
                break;
            }
            case 2: {
                filterKeyOrder = new int[]{1, 2, 0};
                break;
            }
            case 1: {
                filterKeyOrder = new int[]{2, 0, 1};
                break;
            }
            case 3: {
                filterKeyOrder = new int[]{0, 1, 2};
                break;
            }
            case 6: {
                filterKeyOrder = new int[]{1, 2, 3};
                break;
            }
            case 4: {
                filterKeyOrder = new int[]{0, 1, 3};
                break;
            }
            case 5: {
                filterKeyOrder = new int[]{0, 2, 3};
                break;
            }
            case 7: {
                filterKeyOrder = new int[]{0, 2, 3};
                break;
            }
            case 8: {
                filterKeyOrder = new int[]{0, 1, 2};
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return filterKeyOrder;
    }

    public static class DistinctFilterImpl
    extends Filter
    implements ICloseable {
        private static final long serialVersionUID = 1L;
        private final int nominalCapacity;
        private final LinkedHashMap<ISPO, byte[]> lru;
        private final IndexMetadata metadata;
        private final IKeyBuilder keyBuilder;
        private final int[] filterKeyOrder;
        private volatile ICheckpointProtocol index;
        private final AtomicBoolean open = new AtomicBoolean(true);
        private final boolean isBTree = true;
        private volatile MemStore store;

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }

        public void close() {
            if (this.open.compareAndSet(true, false)) {
                if (this.index != null) {
                    this.index.close();
                    this.index = null;
                }
                if (this.store != null) {
                    this.store.close();
                    this.store = null;
                }
            }
        }

        private static <T> T getRequiredProperty(IPropertySet pset, String name) {
            Object val = pset.getProperty(name);
            if (val == null && val == null) {
                throw new IllegalStateException("Required property: " + name + " : " + NativeDistinctFilter.class);
            }
            return (T)val;
        }

        private static <T> T getProperty(IPropertySet pset, String name, T defaultValue) {
            Object val = pset.getProperty(name);
            if (val != null) {
                return (T)val;
            }
            return defaultValue;
        }

        public DistinctFilterImpl(IPropertySet properties) {
            int initialCapacity = DistinctFilterImpl.getProperty(properties, Annotations.INITIAL_CAPACITY, 10000);
            float loadFactor = DistinctFilterImpl.getProperty(properties, Annotations.LOAD_FACTOR, Float.valueOf(0.75f)).floatValue();
            this.lru = new LinkedHashMap(initialCapacity, loadFactor);
            this.nominalCapacity = initialCapacity;
            SPOKeyOrder indexKeyOrder = (SPOKeyOrder)DistinctFilterImpl.getRequiredProperty(properties, "keyOrder");
            this.filterKeyOrder = NativeDistinctFilter.getFilterKeyOrder(indexKeyOrder);
            this.metadata = new IndexMetadata(UUID.randomUUID());
            this.metadata.setBranchingFactor(DistinctFilterImpl.getProperty(properties, BTreeAnnotations.BRANCHING_FACTOR, 256));
            if (this.metadata instanceof HTreeIndexMetadata) {
                ((HTreeIndexMetadata)this.metadata).setAddressBits(DistinctFilterImpl.getProperty(properties, HTreeAnnotations.ADDRESS_BITS, 10));
            }
            this.metadata.setRawRecords(DistinctFilterImpl.getProperty(properties, Annotations.RAW_RECORDS, false));
            this.metadata.setMaxRecLen(0);
            this.metadata.setBloomFilterFactory(BloomFilterFactory.DEFAULT);
            this.metadata.setWriteRetentionQueueCapacity(DistinctFilterImpl.getProperty(properties, Annotations.WRITE_RETENTION_QUEUE_CAPACITY, 4000));
            int ratio = 32;
            DefaultTupleSerializer tupleSer = new DefaultTupleSerializer(new ASCIIKeyBuilderFactory(64), new FrontCodedRabaCoder(32), EmptyRabaValueCoder.INSTANCE);
            this.metadata.setTupleSerializer(tupleSer);
            this.keyBuilder = tupleSer.getKeyBuilder();
        }

        private void evictAll() {
            if (this.index == null) {
                this.allocateIndex();
            }
            int n = this.lru.size();
            byte[][] a = new byte[n][];
            Iterator<Map.Entry<ISPO, byte[]>> itr = this.lru.entrySet().iterator();
            int i = 0;
            while (itr.hasNext()) {
                a[i++] = itr.next().getValue();
                itr.remove();
            }
            Arrays.sort(a, 0, a.length, BytesUtil.UnsignedByteArrayComparator.INSTANCE);
            if (this.index instanceof BTree) {
                for (int i2 = 0; i2 < a.length; ++i2) {
                    this.add((BTree)this.index, a[i2]);
                }
            } else if (this.index instanceof HTree) {
                for (int i3 = 0; i3 < a.length; ++i3) {
                    this.add((HTree)this.index, a[i3]);
                }
            } else {
                throw new AssertionError();
            }
        }

        private void allocateIndex() {
            if (this.index != null) {
                throw new IllegalStateException();
            }
            if (!this.open.get()) {
                throw new IllegalStateException();
            }
            this.store = new MemStore(new MemoryManager(DirectBufferPool.INSTANCE));
            this.index = BTree.create(this.store, this.metadata);
        }

        public boolean isValid(Object obj) {
            ISPO spo = (ISPO)obj;
            return this.add(spo);
        }

        private boolean add(ISPO spo) {
            if (this.lru.containsKey(spo)) {
                return false;
            }
            this.keyBuilder.reset();
            for (int i = 0; i < 3; ++i) {
                IVUtility.encode(this.keyBuilder, spo.get(this.filterKeyOrder[i]));
            }
            byte[] key = this.keyBuilder.getKey();
            if (this.index != null) {
                if (this.index instanceof BTree) {
                    if (((BTree)this.index).contains(key)) {
                        return false;
                    }
                } else if (this.index instanceof HTree) {
                    if (((HTree)this.index).contains(key)) {
                        return false;
                    }
                } else {
                    throw new AssertionError();
                }
            }
            this.lru.put(spo, key);
            if (this.lru.size() >= this.nominalCapacity) {
                this.evictAll();
            }
            return true;
        }

        private boolean add(BTree members, byte[] key) {
            if (members.contains(key)) {
                return false;
            }
            members.insert(key, null);
            return true;
        }

        private boolean add(HTree members, byte[] key) {
            if (members.contains(key)) {
                return false;
            }
            members.insert(key, null);
            return true;
        }
    }

    public static interface Annotations
    extends BOpFilterBase.Annotations,
    BTreeAnnotations,
    HashMapAnnotations {
        public static final int DEFAULT_INITIAL_CAPACITY = 10000;
        public static final int DEFAULT_MAX_RECLEN = 32;
        public static final String KEY_ORDER = "keyOrder";
    }
}

