/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.engine;

import com.bigdata.bop.engine.StaticAnalysisStat;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class StaticAnalysisStats
implements Serializable {
    private static final long serialVersionUID = 3092439315838261120L;
    private final StaticAnalysisStat resolveValuesStat;
    private final StaticAnalysisStat parserStat;
    private final StaticAnalysisStat optimizerLoopStat;
    private final StaticAnalysisStat rangeCountStat;
    private final Map<String, StaticAnalysisStat> optimizerStats = new LinkedHashMap<String, StaticAnalysisStat>();

    public StaticAnalysisStats() {
        this.parserStat = new StaticAnalysisStat("ParseTime");
        this.resolveValuesStat = new StaticAnalysisStat("ResolveValues");
        this.rangeCountStat = new StaticAnalysisStat("RangeCount");
        this.optimizerLoopStat = new StaticAnalysisStat("Optimizers");
    }

    public void registerParserCall(ASTContainer astContainer) {
        Long elapsedNanoSec = astContainer.getQueryParseTime();
        if (elapsedNanoSec != null) {
            this.parserStat.incrementNrCalls();
            this.parserStat.addElapsed(elapsedNanoSec);
        }
        if ((elapsedNanoSec = astContainer.getResolveValuesTime()) != null) {
            this.resolveValuesStat.incrementNrCalls();
            this.resolveValuesStat.addElapsed(elapsedNanoSec);
        }
    }

    public void registerOptimizerLoopCall(long elapsedNanoSec) {
        this.optimizerLoopStat.incrementNrCalls();
        this.optimizerLoopStat.addElapsed(elapsedNanoSec);
    }

    public void registerRangeCountCall(long elapsedNanoSec) {
        this.rangeCountStat.incrementNrCalls();
        this.rangeCountStat.addElapsed(elapsedNanoSec);
    }

    public void registerOptimizerCall(String optimizerName, long elapsedNanoSec) {
        if (this.optimizerStats.get(optimizerName) == null) {
            this.optimizerStats.put(optimizerName, new StaticAnalysisStat(optimizerName));
        }
        StaticAnalysisStat stat = this.optimizerStats.get(optimizerName);
        stat.incrementNrCalls();
        stat.addElapsed(elapsedNanoSec);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("#StaticAnalysisStats: ");
        if (this.parserStat != null) {
            sb.append(this.parserStat);
            sb.append(" ");
        }
        if (this.resolveValuesStat != null) {
            sb.append(this.resolveValuesStat);
            sb.append(" ");
        }
        if (this.optimizerLoopStat != null) {
            sb.append(this.optimizerLoopStat);
            sb.append(" ");
        }
        for (StaticAnalysisStat optimizerStat : this.optimizerStats.values()) {
            sb.append(optimizerStat);
            sb.append(" ");
        }
        return sb.toString();
    }

    public StaticAnalysisStat getParserStat() {
        return this.parserStat;
    }

    public StaticAnalysisStat getResolveValuesStat() {
        return this.resolveValuesStat;
    }

    public StaticAnalysisStat getOptimizerLoopStat() {
        return this.optimizerLoopStat;
    }

    public StaticAnalysisStat getRangeCountStat() {
        return this.rangeCountStat;
    }

    public Collection<StaticAnalysisStat> getOptimizerStats() {
        return this.optimizerStats.values();
    }
}

