/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.engine;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.join.PipelineJoin;
import java.util.Iterator;
import java.util.UUID;
import org.apache.log4j.Logger;

public class SolutionsLog {
    public static final Logger solutionsLog = Logger.getLogger(SolutionsLog.class);
    public static final boolean INFO = solutionsLog.isInfoEnabled();
    private static final StringBuilder sb = new StringBuilder(4096);
    private static boolean first = true;

    private static void prefix(UUID queryId, BOp bop, int bopId, int partitionId, int chunkSize) {
        if (first) {
            solutionsLog.info((Object)"QueryUUID\tbop\tbopId\tpartitionId\tchunkSize\n");
            first = false;
        }
        sb.setLength(0);
        sb.append(queryId);
        sb.append('\t');
        sb.append(bop == null ? "N/A" : bop.getClass().getSimpleName());
        sb.append('\t');
        sb.append(bopId);
        sb.append('\t');
        sb.append(partitionId);
        sb.append('\t');
        sb.append(chunkSize);
        sb.append('\t');
    }

    private static String getPredSummary(BOp bop) {
        IPredicate pred = (IPredicate)bop.getProperty(PipelineJoin.Annotations.PREDICATE);
        if (pred == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Integer predId = pred == null ? null : (Integer)pred.getProperty(BOp.Annotations.BOP_ID);
        sb.append(pred.getClass().getSimpleName());
        sb.append("[" + predId + "](");
        Iterator itr = pred.argIterator();
        boolean first = true;
        while (itr.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            IVariableOrConstant x = (IVariableOrConstant)itr.next();
            if (x.isVar()) {
                sb.append("?");
                sb.append(x.getName());
                continue;
            }
            sb.append(x.get());
        }
        sb.append(")");
        return sb.toString();
    }

    public static synchronized void log(UUID queryId, BOp bop, int bopId, int partitionId, IBindingSet[] a) {
        SolutionsLog.prefix(queryId, bop, bopId, partitionId, a.length);
        int headerLen = sb.length();
        for (IBindingSet bset : a) {
            if (bset == null) {
                sb.append("NA");
            } else {
                sb.append(bset.toString());
            }
            sb.append('\n');
            solutionsLog.info((Object)sb);
            sb.setLength(headerLen);
        }
    }
}

