/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.engine;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IQueryContext;
import com.bigdata.bop.engine.IChunkAccessor;
import com.bigdata.bop.engine.IChunkMessage;
import com.bigdata.bop.engine.IQueryClient;
import com.bigdata.bop.fed.FederatedRunningQuery;
import com.bigdata.bop.solutions.SolutionSetStream;
import com.bigdata.btree.Checkpoint;
import com.bigdata.relation.accesspath.EmptyCloseableIterator;
import com.bigdata.relation.accesspath.ThickCloseableIterator;
import com.bigdata.rwstore.sector.MemStore;
import com.bigdata.stream.Stream;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.rmi.RemoteException;
import java.util.UUID;

public class LocalNativeChunkMessage
implements IChunkMessage<IBindingSet> {
    private static final long serialVersionUID = 1L;
    private final IQueryClient queryController;
    private final UUID queryControllerId;
    private final UUID queryId;
    private final int bopId;
    private final int partitionId;
    private final SolutionSetStream ssstr;
    private final MemStore mmgr;
    private final long byteCount;
    private boolean released;
    private volatile transient ChunkAccessor chunkAccessor = null;

    @Override
    public IQueryClient getQueryController() {
        return this.queryController;
    }

    @Override
    public UUID getQueryControllerId() {
        return this.queryControllerId;
    }

    @Override
    public UUID getQueryId() {
        return this.queryId;
    }

    @Override
    public int getBOpId() {
        return this.bopId;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public boolean isLastInvocation() {
        return false;
    }

    @Override
    public boolean isMaterialized() {
        return true;
    }

    @Override
    public int getSolutionCount() {
        SolutionSetStream ssstr = this.ssstr;
        if (ssstr == null) {
            return 0;
        }
        long nsolutions = ssstr.getStats().getSolutionSetSize();
        if (nsolutions > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Too many solutions for interface to report correctly: solutionCount=" + nsolutions);
        }
        return (int)nsolutions;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public LocalNativeChunkMessage(IQueryClient queryController, UUID queryId, int bopId, int partitionId, IQueryContext queryContext, IBindingSet[] bsets) {
        this(queryController, queryId, bopId, partitionId, queryContext, new IBindingSet[][]{bsets});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalNativeChunkMessage(IQueryClient queryController, UUID queryId, int bopId, int partitionId, IQueryContext queryContext, IBindingSet[][] bindingSetChunks) {
        if (queryController == null) {
            throw new IllegalArgumentException();
        }
        if (queryId == null) {
            throw new IllegalArgumentException();
        }
        if (queryContext == null) {
            throw new IllegalArgumentException();
        }
        if (bindingSetChunks == null) {
            throw new IllegalArgumentException();
        }
        this.queryController = queryController;
        try {
            this.queryControllerId = queryController.getServiceUUID();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        this.queryId = queryId;
        this.bopId = bopId;
        this.partitionId = partitionId;
        this.released = false;
        if (bindingSetChunks.length == 0 || bindingSetChunks.length == 1 && bindingSetChunks[0].length == 0) {
            this.mmgr = null;
            this.ssstr = null;
            this.byteCount = 0L;
        } else {
            Stream.StreamIndexMetadata metadata = new Stream.StreamIndexMetadata(UUID.randomUUID());
            Checkpoint checkpoint = new Checkpoint(metadata);
            MemStore store = new MemStore(queryContext.getMemoryManager().createAllocationContext());
            SolutionSetStream ssstr = new SolutionSetStream(store, checkpoint, metadata, false);
            try (ThickCloseableIterator<IBindingSet[]> itr = new ThickCloseableIterator<IBindingSet[]>((E[])bindingSetChunks);){
                ssstr.put(itr);
            }
            this.ssstr = ssstr;
            this.mmgr = store;
            this.byteCount = store.getByteCount(ssstr.getRootAddr());
        }
    }

    public String toString() {
        return this.getClass().getName() + "{queryId=" + this.queryId + ",bopId=" + this.bopId + ",partitionId=" + this.partitionId + ", ssstr=" + (this.ssstr == null ? "null" : this.ssstr.toString() + ":" + this.ssstr.getStats().toString()) + "}";
    }

    @Override
    public void materialize(FederatedRunningQuery runningQuery) {
    }

    @Override
    public void release() {
        if (!this.released) {
            ChunkAccessor tmp;
            if (this.mmgr != null) {
                this.mmgr.destroy();
            }
            if ((tmp = this.chunkAccessor) != null) {
                tmp.close();
            }
            this.released = true;
        }
    }

    @Override
    public IChunkAccessor<IBindingSet> getChunkAccessor() {
        if (this.chunkAccessor == null) {
            this.chunkAccessor = new ChunkAccessor();
        }
        return this.chunkAccessor;
    }

    private class ChunkAccessor
    implements IChunkAccessor<IBindingSet> {
        private final ICloseableIterator<IBindingSet[]> source;

        public ChunkAccessor() {
            if (LocalNativeChunkMessage.this.released) {
                throw new IllegalStateException();
            }
            this.source = LocalNativeChunkMessage.this.ssstr == null ? new EmptyCloseableIterator<IBindingSet[]>() : LocalNativeChunkMessage.this.ssstr.get();
        }

        @Override
        public ICloseableIterator<IBindingSet[]> iterator() {
            return this.source;
        }

        public void close() {
            this.source.close();
            if (LocalNativeChunkMessage.this.ssstr != null) {
                LocalNativeChunkMessage.this.ssstr.close();
            }
        }
    }
}

