/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.bset;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class ConditionalRoutingOp
extends PipelineOp {
    private static final long serialVersionUID = 1L;

    public ConditionalRoutingOp(ConditionalRoutingOp op) {
        super(op);
    }

    public ConditionalRoutingOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    public ConditionalRoutingOp(BOp[] args, NV ... anns) {
        this(args, NV.asMap(anns));
    }

    public IConstraint getCondition() {
        return (IConstraint)this.getProperty(Annotations.CONDITION);
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ConditionalRouteTask(this, context));
    }

    private static class ConditionalRouteTask
    implements Callable<Void> {
        private final BOpStats stats;
        private final IConstraint condition;
        private final ICloseableIterator<IBindingSet[]> source;
        private final IBlockingBuffer<IBindingSet[]> sink;
        private final IBlockingBuffer<IBindingSet[]> sink2;

        ConditionalRouteTask(ConditionalRoutingOp op, BOpContext<IBindingSet> context) {
            this.stats = context.getStats();
            this.condition = op.getCondition();
            if (this.condition == null) {
                throw new IllegalArgumentException();
            }
            this.source = context.getSource();
            this.sink = context.getSink();
            this.sink2 = context.getSink2();
            if (this.sink == this.sink2) {
                throw new IllegalArgumentException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                while (this.source.hasNext()) {
                    IBindingSet[] chunk = (IBindingSet[])this.source.next();
                    this.stats.chunksIn.increment();
                    this.stats.unitsIn.add(chunk.length);
                    IBindingSet[] def = new IBindingSet[chunk.length];
                    IBindingSet[] alt = this.sink2 == null ? null : new IBindingSet[chunk.length];
                    int ndef = 0;
                    int nalt = 0;
                    for (int i = 0; i < chunk.length; ++i) {
                        if (i % 20 == 0 && Thread.interrupted()) {
                            throw new RuntimeException(new InterruptedException());
                        }
                        IBindingSet bset = chunk[i].clone();
                        if (this.condition.accept(bset)) {
                            def[ndef++] = bset;
                            continue;
                        }
                        if (this.sink2 == null) continue;
                        alt[nalt++] = bset;
                    }
                    if (ndef > 0) {
                        if (ndef == def.length) {
                            this.sink.add(def);
                        } else {
                            this.sink.add(Arrays.copyOf(def, ndef));
                        }
                    }
                    if (nalt <= 0 || this.sink2 == null) continue;
                    if (nalt == alt.length) {
                        this.sink2.add(alt);
                        continue;
                    }
                    this.sink2.add(Arrays.copyOf(alt, nalt));
                }
                this.sink.flush();
                if (this.sink2 != null) {
                    this.sink2.flush();
                }
                Void void_ = null;
                return void_;
            }
            finally {
                this.source.close();
                this.sink.close();
                if (this.sink2 != null) {
                    this.sink2.close();
                }
            }
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations {
        public static final String CONDITION = ConditionalRoutingOp.class.getName() + ".condition";
    }
}

