/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.cache;

import com.bigdata.cache.ICacheEntry;
import com.bigdata.cache.ICacheListener;
import com.bigdata.cache.ICachePolicy;
import com.bigdata.cache.IWeakRefCacheEntry;
import com.bigdata.cache.IWeakRefCacheEntryFactory;
import com.bigdata.cache.WeakCacheEntryFactory;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public final class WeakValueCache<K, T>
implements ICachePolicy<K, T> {
    protected static final Logger log = Logger.getLogger(WeakValueCache.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    public static final int INITIAL_CAPACITY = 1000;
    public static final float LOAD_FACTOR = 0.75f;
    private int _initialCapacity;
    private float _loadFactor;
    private int _nput = 0;
    private int _ninsert = 0;
    private int _ntouch = 0;
    private int _ntest = 0;
    private int _nsuccess = 0;
    private int _nclear = 0;
    private int _nremove = 0;
    private int _highTide = 0;
    private Map<K, IWeakRefCacheEntry<K, T>> _cache;
    private ReferenceQueue<T> _queue;
    private final ICachePolicy<K, T> _delegate;
    private final IWeakRefCacheEntryFactory<K, T> _factory;
    private final IClearReferenceListener<K> _clearReferenceListener;

    public WeakValueCache(ICachePolicy<K, T> delegate) {
        this(1000, 0.75f, delegate, new WeakCacheEntryFactory());
    }

    public WeakValueCache(ICachePolicy<K, T> delegate, IWeakRefCacheEntryFactory<K, T> factory) {
        this(1000, 0.75f, delegate, factory);
    }

    public WeakValueCache(int initialCapacity, float loadFactor, ICachePolicy<K, T> delegate, IWeakRefCacheEntryFactory<K, T> factory) {
        this(initialCapacity, loadFactor, delegate, factory, null);
    }

    public WeakValueCache(int initialCapacity, float loadFactor, ICachePolicy<K, T> delegate, IWeakRefCacheEntryFactory<K, T> factory, IClearReferenceListener<K> clearReferenceListener) {
        if (delegate == null || factory == null) {
            throw new IllegalArgumentException();
        }
        this._initialCapacity = initialCapacity;
        this._loadFactor = loadFactor;
        this._cache = new HashMap<K, IWeakRefCacheEntry<K, T>>(initialCapacity, loadFactor);
        this._queue = new ReferenceQueue();
        this._delegate = delegate;
        this._factory = factory;
        this._clearReferenceListener = clearReferenceListener;
    }

    public ICachePolicy<K, T> getDelegate() {
        return this._delegate;
    }

    @Override
    public synchronized void clear() {
        this.reportStatistics(true);
        this._cache = new HashMap<K, IWeakRefCacheEntry<K, T>>(this._initialCapacity, this._loadFactor);
        this._queue = new ReferenceQueue();
        this._delegate.clear();
    }

    public synchronized void reportStatistics(boolean resetCounters) {
        int size = this._cache.size();
        double hitRatio = (double)this._nsuccess / (double)this._ntest;
        if (INFO) {
            log.info((Object)("WeakValueCache: initialCapacity=" + this._initialCapacity + ", size=" + size + ", highTide=" + this._highTide + ", nput=" + this._nput + ", ninsert=" + this._ninsert + ", ntouch=" + this._ntouch + ", nremove=" + this._nremove + ", nclear=" + this._nclear + ", ntest=" + this._ntest + ", nsuccess=" + this._nsuccess + ", hitRatio=" + hitRatio));
        }
        if (resetCounters) {
            this._nsuccess = 0;
            this._ntest = 0;
            this._nclear = 0;
            this._nremove = 0;
            this._ntouch = 0;
            this._ninsert = 0;
            this._nput = 0;
            this._highTide = 0;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.reportStatistics(false);
    }

    @Override
    public synchronized void put(K oid, T obj, boolean dirty) {
        Object value;
        ++this._nput;
        this._delegate.put(oid, obj, dirty);
        IWeakRefCacheEntry<K, T> entry = this._cache.get(oid);
        Object v0 = value = entry == null ? null : entry.getObject();
        if (value == null) {
            entry = this._factory.newCacheEntry(oid, obj, this._queue);
            this._cache.put(oid, entry);
            ++this._ninsert;
        } else {
            if (value != obj) {
                throw new IllegalStateException("Attempting to change the object in cache under this key: key=" + oid + ", obj=" + obj);
            }
            ++this._ntouch;
        }
        int size = this._cache.size();
        if (size > this._highTide) {
            this._highTide = size;
        }
        this.removeClearedEntries();
    }

    @Override
    public synchronized T get(K oid) {
        ++this._ntest;
        T obj = this._delegate.get(oid);
        if (obj != null) {
            ++this._nsuccess;
        } else {
            IWeakRefCacheEntry<K, T> entry = this._cache.get(oid);
            if (entry != null && (obj = entry.getObject()) != null) {
                this._delegate.put(oid, obj, false);
                ++this._nsuccess;
            }
        }
        this.removeClearedEntries();
        return obj;
    }

    @Override
    public synchronized T remove(K oid) {
        this._delegate.remove(oid);
        IWeakRefCacheEntry<K, T> entry = this._cache.remove(oid);
        ++this._nremove;
        this.removeClearedEntries();
        if (entry != null) {
            return entry.getObject();
        }
        return null;
    }

    private void removeClearedEntries() {
        int counter = 0;
        Reference<T> ref = this._queue.poll();
        while (ref != null) {
            Object oid = ((IWeakRefCacheEntry)((Object)ref)).getKey();
            if (this._cache.get(oid) == ref) {
                if (DEBUG) {
                    log.debug((Object)("Removing cleared reference: key=" + oid));
                }
                this._cache.remove(oid);
                if (this._clearReferenceListener != null) {
                    this._clearReferenceListener.cleared(oid);
                }
                ++counter;
                ++this._nclear;
            }
            ref = this._queue.poll();
        }
        if (counter > 1 && INFO) {
            log.info((Object)("Removed " + counter + " cleared references"));
        }
    }

    @Override
    public void setListener(ICacheListener<K, T> listener) {
        this._delegate.setListener(listener);
    }

    @Override
    public ICacheListener<K, T> getCacheListener() {
        return this._delegate.getCacheListener();
    }

    @Override
    public Iterator<T> iterator() {
        return this._delegate.iterator();
    }

    @Override
    public Iterator<ICacheEntry<K, T>> entryIterator() {
        return this._delegate.entryIterator();
    }

    @Override
    public int size() {
        return this._delegate.size();
    }

    @Override
    public int capacity() {
        return this._delegate.capacity();
    }

    public static interface IClearReferenceListener<K> {
        public void cleared(K var1);
    }
}

