/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.api;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.QuadLike;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

public interface Quad
extends QuadLike<BlankNodeOrIRI> {
    @Override
    public Optional<BlankNodeOrIRI> getGraphName();

    @Override
    public BlankNodeOrIRI getSubject();

    @Override
    public IRI getPredicate();

    @Override
    public RDFTerm getObject();

    default public Triple asTriple() {
        return new Triple(){

            @Override
            public BlankNodeOrIRI getSubject() {
                return Quad.this.getSubject();
            }

            @Override
            public IRI getPredicate() {
                return Quad.this.getPredicate();
            }

            @Override
            public RDFTerm getObject() {
                return Quad.this.getObject();
            }

            @Override
            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof Triple)) {
                    return false;
                }
                Triple other = (Triple)obj;
                return Objects.equals(this.getSubject(), other.getSubject()) && Objects.equals(this.getPredicate(), other.getPredicate()) && Objects.equals(this.getObject(), other.getObject());
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.getSubject(), this.getPredicate(), this.getObject());
            }
        };
    }

    public boolean equals(Object var1);

    public int hashCode();
}

