/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.mem;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.jena.jdbc.JenaDriver;
import org.apache.jena.jdbc.connections.JenaConnection;
import org.apache.jena.jdbc.mem.connections.MemConnection;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sys.JenaSystem;

public class MemDriver
extends JenaDriver {
    public static final String MEM_DRIVER_PREFIX = "mem:";
    public static final String PARAM_DATASET = "dataset";
    public static final String PARAM_EMPTY = "empty";

    public static synchronized void register() throws SQLException {
        DriverManager.registerDriver((Driver)((Object)new MemDriver()));
    }

    public MemDriver() {
        super(0, 1, MEM_DRIVER_PREFIX);
    }

    protected JenaConnection connect(Properties props, int compatibilityLevel) throws SQLException {
        Object dsObj = props.get(PARAM_DATASET);
        String empty = props.getProperty(PARAM_EMPTY);
        if (dsObj == null && empty == null) {
            throw new SQLException("Neither one of the dataset or empty connection parameters is present in the JDBC Connection URL or the provided Properties object");
        }
        if (dsObj != null) {
            if (dsObj instanceof Dataset) {
                return new MemConnection((Dataset)dsObj, 2, true, 0, compatibilityLevel);
            }
            try {
                Dataset ds = DatasetFactory.create();
                RDFDataMgr.read((Dataset)ds, (String)dsObj.toString());
                return new MemConnection(ds, 2, true, 0, compatibilityLevel);
            }
            catch (Exception e) {
                throw new SQLException("Error occurred while reading from the specified RDF dataset file - " + dsObj.toString(), e);
            }
        }
        if (this.isTrue(props, PARAM_EMPTY)) {
            return new MemConnection(DatasetFactory.create(), 2, true, 0, compatibilityLevel);
        }
        throw new SQLException("Insufficient parameters to create a Jena JDBC in-memory connection, please supply a Dataset file/instance via the dataset parameter or supply empty=true to connect to a new empty dataset");
    }

    protected DriverPropertyInfo[] getPropertyInfo(Properties connProps, List<DriverPropertyInfo> baseDriverProps) {
        DriverPropertyInfo[] driverProps;
        if (connProps.containsKey(PARAM_DATASET) || !this.isTrue(connProps, PARAM_EMPTY)) {
            driverProps = new DriverPropertyInfo[1 + baseDriverProps.size()];
            driverProps[0] = new DriverPropertyInfo(PARAM_DATASET, connProps.getProperty(PARAM_DATASET));
            driverProps[0].required = true;
            driverProps[0].description = "Sets a path to a file that should be read in to form an in-memory dataset";
            this.copyBaseProperties(driverProps, baseDriverProps, 1);
        } else if (connProps.containsKey(PARAM_EMPTY)) {
            driverProps = new DriverPropertyInfo[1 + baseDriverProps.size()];
            driverProps[0] = new DriverPropertyInfo(PARAM_EMPTY, connProps.getProperty(PARAM_EMPTY));
            driverProps[0].required = true;
            driverProps[0].choices = new String[]{"true", "false"};
            driverProps[0].description = "Sets that the driver will use an empty in-memory dataset as the initial dataset, when set to true the dataset parameter is not required";
            this.copyBaseProperties(driverProps, baseDriverProps, 1);
        } else {
            driverProps = new DriverPropertyInfo[2 + baseDriverProps.size()];
            driverProps[0] = new DriverPropertyInfo(PARAM_DATASET, connProps.getProperty(PARAM_DATASET));
            driverProps[0].required = true;
            driverProps[0].description = "Sets a path to a file that should be read in to form an in-memory dataset";
            driverProps[1] = new DriverPropertyInfo(PARAM_EMPTY, connProps.getProperty(PARAM_EMPTY));
            driverProps[1].required = false;
            driverProps[1].choices = new String[]{"true", "false"};
            driverProps[1].description = "Sets that the driver will use an empty in-memory dataset as the initial dataset, when set to true the dataset parameter is not required";
            this.copyBaseProperties(driverProps, baseDriverProps, 2);
        }
        return driverProps;
    }

    static {
        try {
            JenaSystem.init();
            MemDriver.register();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to register Jena In-Memory JDBC Driver", e);
        }
    }
}

