/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.sail;

import com.bigdata.rdf.graph.IGASEngine;
import com.bigdata.rdf.graph.IGraphAccessor;
import com.bigdata.rdf.graph.impl.sail.SAILGASEngine;
import com.bigdata.rdf.graph.util.AbstractGraphFixture;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.memory.MemoryStore;

public class SailGraphFixture
extends AbstractGraphFixture {
    private Sail sail = new MemoryStore();

    public SailGraphFixture() throws SailException {
        this.sail.initialize();
    }

    @Override
    public Sail getSail() {
        return this.sail;
    }

    @Override
    public void destroy() throws SailException {
        this.sail.shutDown();
    }

    @Override
    public IGASEngine newGASEngine(int nthreads) {
        return new SAILGASEngine(nthreads);
    }

    @Override
    public IGraphAccessor newGraphAccessor(SailConnection cxn) {
        return new SAILGASEngine.SAILGraphAccessor(cxn);
    }
}

