/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl;

import com.bigdata.rdf.graph.BinderBase;
import com.bigdata.rdf.graph.EdgesEnum;
import com.bigdata.rdf.graph.Factory;
import com.bigdata.rdf.graph.IBinder;
import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGASProgram;
import com.bigdata.rdf.graph.IGASState;
import com.bigdata.rdf.graph.impl.util.VertexDistribution;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public abstract class BaseGASProgram<VS, ES, ST>
implements IGASProgram<VS, ES, ST> {
    private static final Logger log = Logger.getLogger(BaseGASProgram.class);

    @Override
    public EdgesEnum getSampleEdgesFilter() {
        EdgesEnum edges = this.getGatherEdges();
        if (edges == EdgesEnum.NoEdges) {
            edges = this.getScatterEdges();
        }
        return edges;
    }

    @Override
    public EdgesEnum getGatherEdges() {
        return EdgesEnum.InEdges;
    }

    @Override
    public EdgesEnum getScatterEdges() {
        return EdgesEnum.OutEdges;
    }

    @Override
    public void before(IGASContext<VS, ES, ST> ctx) {
        switch (this.getInitialFrontierEnum()) {
            case AllVertices: {
                this.addAllVerticesToFrontier(ctx);
                break;
            }
            case SampledVertices: {
                this.addSampledVerticesToFrontier(ctx);
            }
        }
    }

    private void addAllVerticesToFrontier(IGASContext<VS, ES, ST> ctx) {
        IGASState<VS, ES, ST> gasState = ctx.getGASState();
        EdgesEnum sampleEdges = this.getSampleEdgesFilter();
        VertexDistribution dist = ctx.getGraphAccessor().getDistribution(new Random());
        Object[] initialFrontier = dist.getAll();
        if (ctx.getLinkType() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("linkType=" + ctx.getLinkType()));
            }
            HashSet<Object> filtered = new HashSet<Object>();
            for (Object r : initialFrontier) {
                if (ctx.getGraphAccessor().getEdgeCount(ctx, (Value)r, EdgesEnum.InEdges) == 0L && ctx.getGraphAccessor().getEdgeCount(ctx, (Value)r, EdgesEnum.OutEdges) == 0L) continue;
                filtered.add(r);
            }
            Resource[] filteredFrontier = new Resource[filtered.size()];
            int i = 0;
            for (Object r : filtered) {
                filteredFrontier[i] = r;
                ++i;
            }
            gasState.setFrontier(ctx, (Value[])filteredFrontier);
            if (log.isDebugEnabled()) {
                log.debug((Object)("initialFrontier=" + Arrays.toString(initialFrontier)));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("initialFrontier=" + Arrays.toString(initialFrontier)));
            }
            gasState.setFrontier(ctx, (Value[])initialFrontier);
        }
    }

    private void addSampledVerticesToFrontier(IGASContext<VS, ES, ST> ctx) {
        IGASState<VS, ES, ST> gasState = ctx.getGASState();
        EdgesEnum sampleEdges = this.getSampleEdgesFilter();
        VertexDistribution dist = ctx.getGraphAccessor().getDistribution(new Random());
        Object[] initialFrontier = dist.getUnweightedSample(dist.size(), sampleEdges);
        if (log.isDebugEnabled()) {
            log.debug((Object)("initialFrontier=" + Arrays.toString(initialFrontier)));
        }
        gasState.setFrontier(ctx, (Value[])initialFrontier);
    }

    @Override
    public void initVertex(IGASContext<VS, ES, ST> ctx, IGASState<VS, ES, ST> state, Value u) {
    }

    @Override
    public Factory<Statement, ES> getEdgeStateFactory() {
        return null;
    }

    @Override
    public boolean isChanged(IGASState<VS, ES, ST> state, Value u) {
        return true;
    }

    @Override
    public boolean nextRound(IGASContext<VS, ES, ST> ctx) {
        return true;
    }

    @Override
    public List<IBinder<VS, ES, ST>> getBinderList() {
        LinkedList<IBinder<VS, ES, ST>> tmp = new LinkedList<IBinder<VS, ES, ST>>();
        tmp.add(new BinderBase<VS, ES, ST>(){

            @Override
            public int getIndex() {
                return 0;
            }

            @Override
            public Value bind(ValueFactory vf, IGASState<VS, ES, ST> state, Value u) {
                return u;
            }
        });
        return tmp;
    }

    public static interface Bindings {
        public static final int VISITED = 0;
    }
}

