/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.jena.arq.querybuilder.Converters;
import org.apache.jena.arq.querybuilder.clauses.WhereClause;
import org.apache.jena.graph.Node;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Add;
import org.apache.jena.sparql.expr.E_BNode;
import org.apache.jena.sparql.expr.E_Bound;
import org.apache.jena.sparql.expr.E_Call;
import org.apache.jena.sparql.expr.E_Coalesce;
import org.apache.jena.sparql.expr.E_Conditional;
import org.apache.jena.sparql.expr.E_Datatype;
import org.apache.jena.sparql.expr.E_DateTimeDay;
import org.apache.jena.sparql.expr.E_DateTimeHours;
import org.apache.jena.sparql.expr.E_DateTimeMinutes;
import org.apache.jena.sparql.expr.E_DateTimeMonth;
import org.apache.jena.sparql.expr.E_DateTimeSeconds;
import org.apache.jena.sparql.expr.E_DateTimeTZ;
import org.apache.jena.sparql.expr.E_DateTimeTimezone;
import org.apache.jena.sparql.expr.E_DateTimeYear;
import org.apache.jena.sparql.expr.E_Divide;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_Exists;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.E_FunctionDynamic;
import org.apache.jena.sparql.expr.E_GreaterThan;
import org.apache.jena.sparql.expr.E_GreaterThanOrEqual;
import org.apache.jena.sparql.expr.E_IRI;
import org.apache.jena.sparql.expr.E_IsBlank;
import org.apache.jena.sparql.expr.E_IsIRI;
import org.apache.jena.sparql.expr.E_IsLiteral;
import org.apache.jena.sparql.expr.E_IsNumeric;
import org.apache.jena.sparql.expr.E_Lang;
import org.apache.jena.sparql.expr.E_LangMatches;
import org.apache.jena.sparql.expr.E_LessThan;
import org.apache.jena.sparql.expr.E_LessThanOrEqual;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.E_MD5;
import org.apache.jena.sparql.expr.E_Multiply;
import org.apache.jena.sparql.expr.E_NotEquals;
import org.apache.jena.sparql.expr.E_NotExists;
import org.apache.jena.sparql.expr.E_NotOneOf;
import org.apache.jena.sparql.expr.E_Now;
import org.apache.jena.sparql.expr.E_NumAbs;
import org.apache.jena.sparql.expr.E_NumCeiling;
import org.apache.jena.sparql.expr.E_NumFloor;
import org.apache.jena.sparql.expr.E_NumRound;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.E_Random;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.jena.sparql.expr.E_SHA1;
import org.apache.jena.sparql.expr.E_SHA224;
import org.apache.jena.sparql.expr.E_SHA256;
import org.apache.jena.sparql.expr.E_SHA384;
import org.apache.jena.sparql.expr.E_SHA512;
import org.apache.jena.sparql.expr.E_SameTerm;
import org.apache.jena.sparql.expr.E_Str;
import org.apache.jena.sparql.expr.E_StrAfter;
import org.apache.jena.sparql.expr.E_StrBefore;
import org.apache.jena.sparql.expr.E_StrConcat;
import org.apache.jena.sparql.expr.E_StrContains;
import org.apache.jena.sparql.expr.E_StrDatatype;
import org.apache.jena.sparql.expr.E_StrEncodeForURI;
import org.apache.jena.sparql.expr.E_StrEndsWith;
import org.apache.jena.sparql.expr.E_StrLang;
import org.apache.jena.sparql.expr.E_StrLength;
import org.apache.jena.sparql.expr.E_StrLowerCase;
import org.apache.jena.sparql.expr.E_StrReplace;
import org.apache.jena.sparql.expr.E_StrStartsWith;
import org.apache.jena.sparql.expr.E_StrSubstring;
import org.apache.jena.sparql.expr.E_StrUUID;
import org.apache.jena.sparql.expr.E_StrUpperCase;
import org.apache.jena.sparql.expr.E_Subtract;
import org.apache.jena.sparql.expr.E_UUID;
import org.apache.jena.sparql.expr.E_UnaryMinus;
import org.apache.jena.sparql.expr.E_UnaryPlus;
import org.apache.jena.sparql.expr.E_Version;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprNone;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.syntax.Element;

public class ExprFactory {
    private final PrefixMapping pMap;

    public ExprFactory(PrefixMapping pMap) {
        this.pMap = pMap;
    }

    public ExprFactory() {
        this(PrefixMapping.Extended);
    }

    public final E_Random rand() {
        return new E_Random();
    }

    public final E_StrUUID struuid() {
        return new E_StrUUID();
    }

    public final E_UUID uuid() {
        return new E_UUID();
    }

    public final E_Version version() {
        return new E_Version();
    }

    public final E_Now now() {
        return new E_Now();
    }

    public final E_Bound bound(Object expr) {
        return new E_Bound(this.asExpr(expr));
    }

    public final E_Datatype datatype(Object expr) {
        return new E_Datatype(this.asExpr(expr));
    }

    public final E_DateTimeDay day(Object expr) {
        return new E_DateTimeDay(this.asExpr(expr));
    }

    public final E_DateTimeHours hours(Object expr) {
        return new E_DateTimeHours(this.asExpr(expr));
    }

    public final E_DateTimeMinutes minutes(Object expr) {
        return new E_DateTimeMinutes(this.asExpr(expr));
    }

    public final E_DateTimeMonth month(Object expr) {
        return new E_DateTimeMonth(this.asExpr(expr));
    }

    public final E_DateTimeSeconds seconds(Object expr) {
        return new E_DateTimeSeconds(this.asExpr(expr));
    }

    public final E_DateTimeTimezone timezone(Object expr) {
        return new E_DateTimeTimezone(this.asExpr(expr));
    }

    public final E_DateTimeTZ tz(Object expr) {
        return new E_DateTimeTZ(this.asExpr(expr));
    }

    public final E_DateTimeYear year(Object expr) {
        return new E_DateTimeYear(this.asExpr(expr));
    }

    public final E_IRI iri(Object expr) {
        return new E_IRI(this.asExpr(expr));
    }

    public final E_IsBlank isBlank(Object expr) {
        return new E_IsBlank(this.asExpr(expr));
    }

    public final E_IsIRI isIRI(Object expr) {
        return new E_IsIRI(this.asExpr(expr));
    }

    public final E_IsLiteral isLiteral(Object expr) {
        return new E_IsLiteral(this.asExpr(expr));
    }

    public final E_IsNumeric isNumeric(Object expr) {
        return new E_IsNumeric(this.asExpr(expr));
    }

    public final E_Lang lang(Object expr) {
        return new E_Lang(this.asExpr(expr));
    }

    public final E_LogicalNot not(Object expr) {
        return new E_LogicalNot(this.asExpr(expr));
    }

    public final E_NumAbs abs(Object expr) {
        return new E_NumAbs(this.asExpr(expr));
    }

    public final E_NumCeiling ceil(Object expr) {
        return new E_NumCeiling(this.asExpr(expr));
    }

    public final E_NumFloor floor(Object expr) {
        return new E_NumFloor(this.asExpr(expr));
    }

    public final E_NumRound round(Object expr) {
        return new E_NumRound(this.asExpr(expr));
    }

    public final E_Str str(Object expr) {
        return new E_Str(this.asExpr(expr));
    }

    public final E_StrEncodeForURI encode(Object expr) {
        return new E_StrEncodeForURI(this.asExpr(expr));
    }

    public final E_StrLength strlen(Object expr) {
        return new E_StrLength(this.asExpr(expr));
    }

    public final E_StrLowerCase lcase(Object expr) {
        return new E_StrLowerCase(this.asExpr(expr));
    }

    public final E_StrUpperCase ucase(Object expr) {
        return new E_StrUpperCase(this.asExpr(expr));
    }

    public final E_UnaryMinus minus(Object expr) {
        return new E_UnaryMinus(this.asExpr(expr));
    }

    public final E_UnaryPlus plus(Object expr) {
        return new E_UnaryPlus(this.asExpr(expr));
    }

    public final E_MD5 md5(Object expr) {
        return new E_MD5(this.asExpr(expr));
    }

    public final E_SHA1 sha1(Object expr) {
        return new E_SHA1(this.asExpr(expr));
    }

    public final E_SHA224 sha224(Object expr) {
        return new E_SHA224(this.asExpr(expr));
    }

    public final E_SHA256 sha256(Object expr) {
        return new E_SHA256(this.asExpr(expr));
    }

    public final E_SHA384 sha384(Object expr) {
        return new E_SHA384(this.asExpr(expr));
    }

    public final E_SHA512 sha512(Object expr) {
        return new E_SHA512(this.asExpr(expr));
    }

    public final E_Add add(Object expr1, Object expr2) {
        return new E_Add(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_Divide divide(Object expr1, Object expr2) {
        return new E_Divide(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_Equals eq(Object expr1, Object expr2) {
        return new E_Equals(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_GreaterThan gt(Object expr1, Object expr2) {
        return new E_GreaterThan(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_GreaterThanOrEqual ge(Object expr1, Object expr2) {
        return new E_GreaterThanOrEqual(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_LangMatches langMatches(Object expr1, Object expr2) {
        return new E_LangMatches(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_LessThan lt(Object expr1, Object expr2) {
        return new E_LessThan(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_LessThanOrEqual le(Object expr1, Object expr2) {
        return new E_LessThanOrEqual(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_LogicalAnd and(Object expr1, Object expr2) {
        return new E_LogicalAnd(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_LogicalOr or(Object expr1, Object expr2) {
        return new E_LogicalOr(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_Multiply multiply(Object expr1, Object expr2) {
        return new E_Multiply(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_NotEquals ne(Object expr1, Object expr2) {
        return new E_NotEquals(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_SameTerm sameTerm(Object expr1, Object expr2) {
        return new E_SameTerm(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_StrAfter strafter(Object expr1, Object expr2) {
        return new E_StrAfter(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_StrBefore strbefore(Object expr1, Object expr2) {
        return new E_StrBefore(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_StrContains contains(Object expr1, Object expr2) {
        return new E_StrContains(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_StrDatatype strdt(Object expr1, Object expr2) {
        return new E_StrDatatype(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_StrEndsWith strends(Object expr1, Object expr2) {
        return new E_StrEndsWith(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_StrLang strlang(Object expr1, Object expr2) {
        return new E_StrLang(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_StrStartsWith strstarts(Object expr1, Object expr2) {
        return new E_StrStartsWith(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_Subtract subtract(Object expr1, Object expr2) {
        return new E_Subtract(this.asExpr(expr1), this.asExpr(expr2));
    }

    public final E_Conditional cond(Expr condition, Expr thenExpr, Expr elseExpr) {
        return new E_Conditional(condition, thenExpr, elseExpr);
    }

    public final E_BNode bnode(Object expr1) {
        return new E_BNode(this.asExpr(expr1));
    }

    public final E_BNode bnode() {
        return new E_BNode();
    }

    public final E_FunctionDynamic call(Object function, ExprList args) {
        return new E_FunctionDynamic(this.asExpr(function), args);
    }

    public final E_FunctionDynamic call(Object function, Object ... args) {
        return this.call((Object)this.asExpr(function), this.asList(args));
    }

    public final E_Call call(ExprList args) {
        return new E_Call(args);
    }

    public final E_Coalesce coalesce(ExprList args) {
        return new E_Coalesce(args);
    }

    public final E_Coalesce coalesce(Object ... args) {
        return new E_Coalesce(this.asList(args));
    }

    public final E_Function function(String name, ExprList args) {
        return new E_Function(name, args);
    }

    public final E_NotOneOf notin(Object expr, ExprList list) {
        return new E_NotOneOf(this.asExpr(expr), list);
    }

    public final E_NotOneOf notin(Object expr, Object ... list) {
        return new E_NotOneOf(this.asExpr(expr), this.asList(list));
    }

    public final E_OneOf in(Object expr, ExprList list) {
        return new E_OneOf(this.asExpr(expr), list);
    }

    public final E_OneOf in(Object expr, Object ... list) {
        return new E_OneOf(this.asExpr(expr), this.asList(list));
    }

    public final E_Regex regex(Object expr, Object pattern, Object flags) {
        return new E_Regex(this.asExpr(expr), this.asExpr(pattern), this.asExpr(flags));
    }

    public final E_Regex regex(Object expr, String pattern, String flags) {
        return new E_Regex(this.asExpr(expr), pattern, flags);
    }

    public final E_StrConcat concat(ExprList list) {
        return new E_StrConcat(list);
    }

    public final E_StrConcat concat(Object ... list) {
        return new E_StrConcat(this.asList(list));
    }

    public final E_StrReplace replace(Object arg, Object pattern, Object replacement, Object flags) {
        return new E_StrReplace(this.asExpr(arg), this.asExpr(pattern), this.asExpr(replacement), this.asExpr(flags));
    }

    public final E_StrReplace replace(Object arg, Object pattern, Object replacement) {
        return new E_StrReplace(this.asExpr(arg), this.asExpr(pattern), this.asExpr(replacement), null);
    }

    public final E_StrSubstring substr(Object src, Object loc, Object len) {
        return new E_StrSubstring(this.asExpr(src), this.asExpr(loc), this.asExpr(len));
    }

    public final E_StrSubstring substr(Object src, Object loc) {
        return new E_StrSubstring(this.asExpr(src), this.asExpr(loc), null);
    }

    public final E_Exists exists(WhereClause<?> whereClause) {
        return new E_Exists((Element)whereClause.getWhereHandler().getClause());
    }

    public final E_NotExists notexists(WhereClause<?> whereClause) {
        return new E_NotExists((Element)whereClause.getWhereHandler().getClause());
    }

    public final ExprNone none() {
        return (ExprNone)Expr.NONE;
    }

    public final ExprVar asVar(Object o) {
        if (o instanceof ExprVar) {
            return (ExprVar)o;
        }
        Var v = Converters.makeVar(o);
        return v == null ? null : new ExprVar(v);
    }

    public final ExprList asList(Object ... args) {
        List lst = Arrays.asList(args).stream().map(arg -> this.asExpr(arg)).collect(Collectors.toList());
        return new ExprList(lst);
    }

    public final ExprList list() {
        return new ExprList();
    }

    public final Expr asExpr(Object o) {
        return ExprFactory.asExpr(o, this.pMap);
    }

    @Deprecated
    public final String quote(String s) {
        return Converters.quoted(s);
    }

    public static final Expr asExpr(Object o, PrefixMapping pMap) {
        if (o == null) {
            return Expr.NONE;
        }
        if (o instanceof Expr) {
            return (Expr)o;
        }
        Node n = Converters.makeNode(o, pMap);
        if (n.isVariable()) {
            return new ExprVar(Var.alloc((Node)n));
        }
        return NodeValue.makeNode((Node)n);
    }
}

