/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.formats;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.semanticweb.owlapi.formats.AbstractRDFNonPrefixDocumentFormat;
import org.semanticweb.owlapi.formats.RioRDFDocumentFormat;
import org.semanticweb.owlapi.model.MIMETypeAware;

public class RioRDFNonPrefixDocumentFormat
extends AbstractRDFNonPrefixDocumentFormat
implements MIMETypeAware,
RioRDFDocumentFormat {
    private final String formatName;
    private transient RDFFormat format;

    public RioRDFNonPrefixDocumentFormat(RDFFormat format) {
        this.format = format;
        this.formatName = this.format.getName();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (RDFFormat f : RDFParserRegistry.getInstance().getKeys()) {
            if (!f.getName().equals(this.formatName)) continue;
            this.format = f;
            return;
        }
    }

    public String getKey() {
        return this.format.getName();
    }

    @Override
    public RDFFormat getRioFormat() {
        return this.format;
    }

    @Nullable
    public String getDefaultMIMEType() {
        return this.format.getDefaultMIMEType();
    }

    public List<String> getMIMETypes() {
        return this.format.getMIMETypes();
    }

    public boolean handlesMimeType(String mimeType) {
        return this.format.hasMIMEType(mimeType);
    }
}

