/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.remote;

import com.bigdata.rdf.sail.webapp.client.EncodeDecodeValue;
import com.bigdata.rdf.sail.webapp.client.IPreparedQuery;
import org.openrdf.model.URI;
import org.openrdf.query.Binding;
import org.openrdf.query.impl.AbstractQuery;

public abstract class AbstractBigdataRemoteQuery
extends AbstractQuery {
    private String baseURI;

    public AbstractBigdataRemoteQuery(String baseURI) {
        this.baseURI = baseURI;
    }

    protected void configureConnectOptions(IPreparedQuery q) {
        if (this.baseURI != null) {
            q.addRequestParam("baseURI", this.baseURI);
        }
        q.addRequestParam("includeInferred", Boolean.toString(this.includeInferred));
        if (this.maxQueryTime > 0) {
            q.addRequestParam("maxQueryTimeMillis", Long.toString(1000L * (long)this.maxQueryTime));
        }
        if (this.dataset != null) {
            String[] defaultGraphs = new String[this.dataset.getDefaultGraphs().size()];
            int i = 0;
            for (URI defaultGraphURI : this.dataset.getDefaultGraphs()) {
                defaultGraphs[i++] = String.valueOf(defaultGraphURI);
            }
            q.addRequestParam(q.isUpdate() ? "using-graph-uri" : "default-graph-uri", defaultGraphs);
            String[] namedGraphs = new String[this.dataset.getNamedGraphs().size()];
            i = 0;
            for (URI namedGraphURI : this.dataset.getNamedGraphs()) {
                namedGraphs[i++] = String.valueOf(String.valueOf(namedGraphURI));
            }
            q.addRequestParam(q.isUpdate() ? "using-named-graph-uri" : "named-graph-uri", namedGraphs);
        }
        for (Binding binding : this.bindings) {
            String paramName = "$" + binding.getName();
            String paramValue = EncodeDecodeValue.encodeValue(binding.getValue());
            q.addRequestParam(paramName, paramValue);
        }
    }
}

