/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security.proxytrust;

import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.security.Permission;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.export.Exporter;
import net.jini.security.Security;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ProxyTrust;
import net.jini.security.proxytrust.ProxyTrustInvocationHandler;
import net.jini.security.proxytrust.ServerProxyTrust;
import net.jini.security.proxytrust.TrustEquivalence;

public class ProxyTrustExporter
implements Exporter {
    private static final Permission loaderPermission = new RuntimePermission("getClassLoader");
    private static final Executor systemThreadPool = (Executor)Security.doPrivileged(new GetThreadPoolAction(false));
    private static final Set refs = new HashSet();
    private static final ReferenceQueue queue = new ReferenceQueue();
    private static Reaper reaper = null;
    private final Exporter mainExporter;
    private final Exporter bootExporter;
    private final ClassLoader loader;
    private WeakRef ref = null;

    public ProxyTrustExporter(Exporter mainExporter, Exporter bootExporter) {
        this(mainExporter, bootExporter, null);
    }

    public ProxyTrustExporter(Exporter mainExporter, Exporter bootExporter, ClassLoader loader) {
        if (mainExporter == null || bootExporter == null) {
            throw new NullPointerException("exporter is null");
        }
        this.mainExporter = mainExporter;
        this.bootExporter = bootExporter;
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Remote export(Remote impl) throws ExportException {
        Remote remote;
        block21: {
            Remote boot;
            block22: {
                SecurityManager sm;
                if (impl != null && !(impl instanceof ServerProxyTrust)) {
                    throw new IllegalArgumentException("must implement ServerProxyTrust");
                }
                if (this.loader == null && (sm = System.getSecurityManager()) != null) {
                    sm.checkPermission(loaderPermission);
                }
                Remote main = this.mainExporter.export(impl);
                Class<?> c = main.getClass();
                LinkedList ifaces = new LinkedList();
                boot = null;
                boolean ok = false;
                try {
                    Class sup;
                    if (!(main instanceof RemoteMethodControl)) {
                        throw new ExportException("main proxy must implement RemoteMethodControl");
                    }
                    if (!(main instanceof TrustEquivalence)) {
                        throw new ExportException("main proxy must implement TrustEquivalence");
                    }
                    boolean needPub = !Modifier.isPublic(c.getModifiers());
                    for (sup = c; sup != null; sup = sup.getSuperclass()) {
                        Class<?>[] ifs = sup.getInterfaces();
                        int i = ifs.length;
                        while (--i >= 0) {
                            if (needPub && !Modifier.isPublic(ifs[i].getModifiers())) {
                                throw new ExportException("main proxy implements non-public interface");
                            }
                            ifaces.remove(ifs[i]);
                            ifaces.addFirst(ifs[i]);
                        }
                    }
                    this.ref = new WeakRef(impl);
                    sup = refs;
                    synchronized (sup) {
                        if (reaper == null) {
                            reaper = new Reaper();
                            systemThreadPool.execute(reaper, "ProxyTrustExporter.Reaper");
                        }
                        refs.add(this.ref);
                    }
                    boot = this.bootExporter.export(this.ref.boot);
                    if (!(boot instanceof ProxyTrust)) {
                        throw new ExportException("bootstrap proxy must implement ProxyTrust");
                    }
                    if (!(boot instanceof RemoteMethodControl)) {
                        throw new ExportException("bootstrap proxy must implement RemoteMethodControl");
                    }
                    if (!(boot instanceof TrustEquivalence)) {
                        throw new ExportException("bootstrap proxy must implement TrustEquivalence");
                    }
                    Remote proxy = (Remote)Proxy.newProxyInstance(this.loader != null ? this.loader : c.getClassLoader(), ifaces.toArray(new Class[ifaces.size()]), (InvocationHandler)new ProxyTrustInvocationHandler((RemoteMethodControl)main, (ProxyTrust)boot));
                    ok = true;
                    remote = proxy;
                    Object var13_13 = null;
                    if (ok) break block21;
                    if (this.ref == null) break block22;
                }
                catch (IllegalArgumentException e) {
                    try {
                        throw new ExportException("export failed", e);
                    }
                    catch (Throwable throwable) {
                        block23: {
                            Object var13_14 = null;
                            if (ok) break block23;
                            if (this.ref != null) {
                                this.ref.enqueue();
                            }
                            if (boot != null) {
                                this.bootExporter.unexport(true);
                            }
                            this.mainExporter.unexport(true);
                        }
                        throw throwable;
                    }
                }
                this.ref.enqueue();
            }
            if (boot != null) {
                this.bootExporter.unexport(true);
            }
            this.mainExporter.unexport(true);
        }
        return remote;
    }

    public synchronized boolean unexport(boolean force) {
        if (!this.mainExporter.unexport(force)) {
            return false;
        }
        this.bootExporter.unexport(true);
        if (this.ref != null) {
            this.ref.enqueue();
        }
        return true;
    }

    private static class ProxyTrustImpl
    implements ProxyTrust {
        private final Reference ref;

        ProxyTrustImpl(Reference ref) {
            this.ref = ref;
        }

        public TrustVerifier getProxyVerifier() throws RemoteException {
            ServerProxyTrust impl = (ServerProxyTrust)this.ref.get();
            if (impl == null) {
                throw new UnsupportedOperationException("impl is gone");
            }
            return impl.getProxyVerifier();
        }
    }

    private static class Reaper
    implements Runnable {
        Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    Reference ref = queue.remove();
                    ref.clear();
                    Set set = refs;
                    synchronized (set) {
                        refs.remove(ref);
                        if (refs.isEmpty()) {
                            reaper = null;
                            return;
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private static class WeakRef
    extends WeakReference {
        ProxyTrust boot = new ProxyTrustImpl(this);

        WeakRef(Remote impl) {
            super(impl, queue);
        }

        public void clear() {
            super.clear();
            this.boot = null;
        }
    }
}

