/*
 * Decompiled with CFR 0.152.
 */
package net.jini.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.jini.io.MarshalInputStream;
import net.jini.io.MarshalOutputStream;
import net.jini.io.MarshalledObject;
import net.jini.io.context.IntegrityEnforcement;

public class MarshalledInstance
implements Serializable {
    private byte[] objBytes = null;
    private byte[] locBytes = null;
    private int hash;
    static final long serialVersionUID = -5187033771082433496L;
    static /* synthetic */ Class class$net$jini$io$MarshalledObject;
    static /* synthetic */ Class class$java$rmi$MarshalledObject;

    public MarshalledInstance(Object obj) throws IOException {
        this(obj, Collections.EMPTY_SET);
    }

    public MarshalledInstance(Object obj, Collection context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (obj == null) {
            this.hash = 13;
            return;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ByteArrayOutputStream lout = new ByteArrayOutputStream();
        MarshalledInstanceOutputStream out = new MarshalledInstanceOutputStream(bout, lout, context);
        out.writeObject(obj);
        out.flush();
        this.objBytes = bout.toByteArray();
        this.locBytes = out.hadAnnotations() ? lout.toByteArray() : null;
        int h = 0;
        for (int i = 0; i < this.objBytes.length; ++i) {
            h = 31 * h + this.objBytes[i];
        }
        this.hash = h;
    }

    public MarshalledInstance(java.rmi.MarshalledObject mo) {
        if (mo == null) {
            throw new NullPointerException();
        }
        MarshalledObject privateMO = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(mo);
            oos.flush();
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            FromMOInputStream ois = new FromMOInputStream(bais);
            privateMO = (MarshalledObject)ois.readObject();
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError((Object)cnfe);
        }
        this.objBytes = privateMO.objBytes;
        this.locBytes = privateMO.locBytes;
        this.hash = privateMO.hash;
    }

    public java.rmi.MarshalledObject convertToMarshalledObject() {
        MarshalledObject privateMO = new MarshalledObject();
        privateMO.objBytes = this.objBytes;
        privateMO.locBytes = this.locBytes;
        privateMO.hash = this.hash;
        java.rmi.MarshalledObject mo = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(privateMO);
            oos.flush();
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ToMOInputStream ois = new ToMOInputStream(bais);
            mo = (java.rmi.MarshalledObject)ois.readObject();
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError((Object)cnfe);
        }
        return mo;
    }

    public Object get(boolean verifyCodebaseIntegrity) throws IOException, ClassNotFoundException {
        return this.get(null, verifyCodebaseIntegrity, null, null);
    }

    public Object get(ClassLoader defaultLoader, final boolean verifyCodebaseIntegrity, ClassLoader verifierLoader, Collection context) throws IOException, ClassNotFoundException {
        if (this.objBytes == null) {
            return null;
        }
        if (context == null) {
            context = Collections.singleton(new IntegrityEnforcement(){

                public boolean integrityEnforced() {
                    return verifyCodebaseIntegrity;
                }
            });
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(this.objBytes);
        ByteArrayInputStream lin = this.locBytes == null ? null : new ByteArrayInputStream(this.locBytes);
        MarshalledInstanceInputStream in = new MarshalledInstanceInputStream(bin, lin, defaultLoader, verifyCodebaseIntegrity, verifierLoader, context);
        in.useCodebaseAnnotations();
        Object obj = in.readObject();
        in.close();
        return obj;
    }

    public boolean fullyEquals(Object obj) {
        if (this.equals(obj)) {
            MarshalledInstance other = (MarshalledInstance)obj;
            return Arrays.equals(this.locBytes, other.locBytes);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MarshalledInstance) {
            MarshalledInstance other = (MarshalledInstance)obj;
            if (this.hash != other.hash) {
                return false;
            }
            return Arrays.equals(this.objBytes, other.objBytes);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.objBytes == null && (this.hash != 13 || this.locBytes != null)) {
            throw new InvalidObjectException("Bad hash or annotation");
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Bad class hierarchy");
    }

    private static class ToMOInputStream
    extends ObjectInputStream {
        public ToMOInputStream(InputStream in) throws IOException {
            super(in);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (desc.getName().equals("net.jini.io.MarshalledObject")) {
                return class$java$rmi$MarshalledObject == null ? (class$java$rmi$MarshalledObject = MarshalledInstance.class$("java.rmi.MarshalledObject")) : class$java$rmi$MarshalledObject;
            }
            return super.resolveClass(desc);
        }
    }

    private static class FromMOInputStream
    extends ObjectInputStream {
        public FromMOInputStream(InputStream in) throws IOException {
            super(in);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (desc.getName().equals("java.rmi.MarshalledObject")) {
                return class$net$jini$io$MarshalledObject == null ? (class$net$jini$io$MarshalledObject = MarshalledInstance.class$("net.jini.io.MarshalledObject")) : class$net$jini$io$MarshalledObject;
            }
            return super.resolveClass(desc);
        }
    }

    private static class MarshalledInstanceInputStream
    extends MarshalInputStream {
        private ObjectInputStream locIn;

        MarshalledInstanceInputStream(InputStream objIn, InputStream locIn, ClassLoader defaultLoader, boolean verifyCodebaseIntegrity, ClassLoader verifierLoader, Collection context) throws IOException {
            super(objIn, defaultLoader, verifyCodebaseIntegrity, verifierLoader, context);
            this.locIn = locIn == null ? null : new ObjectInputStream(locIn);
        }

        protected String readAnnotation() throws IOException, ClassNotFoundException {
            return this.locIn == null ? null : (String)this.locIn.readObject();
        }
    }

    private static class MarshalledInstanceOutputStream
    extends MarshalOutputStream {
        private ObjectOutputStream locOut;
        private boolean hadAnnotations;

        public MarshalledInstanceOutputStream(OutputStream objOut, OutputStream locOut, Collection context) throws IOException {
            super(objOut, context);
            this.locOut = new ObjectOutputStream(locOut);
            this.hadAnnotations = false;
        }

        public boolean hadAnnotations() {
            return this.hadAnnotations;
        }

        protected void writeAnnotation(String loc) throws IOException {
            this.hadAnnotations |= loc != null;
            this.locOut.writeObject(loc);
        }

        public void flush() throws IOException {
            super.flush();
            this.locOut.flush();
        }
    }
}

