/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.kerberos;

import com.sun.jini.discovery.UnicastDiscoveryClient;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.EndpointBasedClient;
import com.sun.jini.discovery.internal.EndpointInternals;
import com.sun.jini.discovery.internal.KerberosEndpointInternalsAccess;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.net.SocketFactory;
import javax.security.auth.kerberos.KerberosPrincipal;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.ServerMinPrincipal;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.kerberos.KerberosEndpoint;

public class Client
implements UnicastDiscoveryClient {
    private final ClientImpl impl = new ClientImpl();

    public String getFormatName() {
        return this.impl.getFormatName();
    }

    public void checkUnicastDiscoveryConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        this.impl.checkUnicastDiscoveryConstraints(constraints);
    }

    public UnicastResponse doUnicastDiscovery(Socket socket, InvocationConstraints constraints, ClassLoader defaultLoader, ClassLoader verifierLoader, Collection context, ByteBuffer sent, ByteBuffer received) throws IOException, ClassNotFoundException {
        return this.impl.doUnicastDiscovery(socket, constraints, defaultLoader, verifierLoader, context, sent, received);
    }

    private static final class ClientImpl
    extends EndpointBasedClient {
        private static EndpointInternals epi = (EndpointInternals)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return KerberosEndpointInternalsAccess.get();
            }
        });

        ClientImpl() {
            super("net.jini.discovery.kerberos", epi);
        }

        protected Endpoint getEndpoint(SocketFactory factory, InvocationConstraints constraints) throws UnsupportedConstraintException {
            return KerberosEndpoint.getInstance("ignored", 1, ClientImpl.getKerberosPrincipal(constraints), factory);
        }

        private static KerberosPrincipal getKerberosPrincipal(InvocationConstraints constraints) throws UnsupportedConstraintException {
            Set s;
            InvocationConstraint c;
            KerberosPrincipal principal = null;
            Iterator i = constraints.requirements().iterator();
            while (i.hasNext()) {
                c = (InvocationConstraint)i.next();
                if (!(c instanceof ServerMinPrincipal)) continue;
                s = ((ServerMinPrincipal)c).elements();
                if (s.size() > 1) {
                    throw new UnsupportedConstraintException("multiple server principals");
                }
                Principal p = (Principal)s.iterator().next();
                if (!(p instanceof KerberosPrincipal)) {
                    throw new UnsupportedConstraintException("non-kerberos server principal");
                }
                if (principal == null) {
                    principal = (KerberosPrincipal)p;
                    continue;
                }
                if (principal.equals(p)) continue;
                throw new UnsupportedConstraintException("multiple server principals");
            }
            if (principal != null) {
                return principal;
            }
            i = constraints.preferences().iterator();
            while (i.hasNext()) {
                c = (InvocationConstraint)i.next();
                if (!(c instanceof ServerMinPrincipal)) continue;
                s = ((ServerMinPrincipal)c).elements();
                Iterator j = s.iterator();
                while (j.hasNext()) {
                    Principal p = (Principal)j.next();
                    if (!(p instanceof KerberosPrincipal)) continue;
                    return (KerberosPrincipal)p;
                }
            }
            throw new UnsupportedConstraintException("no kerberos principal");
        }
    }
}

