/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia;

import com.bigdata.ganglia.AbstractGangliaMessage;
import com.bigdata.ganglia.GangliaMessageTypeEnum;
import com.bigdata.ganglia.IGangliaMetricMessage;

public class GangliaMetricMessage
extends AbstractGangliaMessage
implements IGangliaMetricMessage {
    private final String format;
    private final Object value;

    public GangliaMetricMessage(GangliaMessageTypeEnum recordType, String hostName, String metricName, boolean spoof, String format, Object value) {
        super(recordType, hostName, metricName, spoof);
        switch (recordType) {
            case DOUBLE: 
            case FLOAT: 
            case INT32: 
            case INT16: 
            case STRING: 
            case UINT32: 
            case UINT16: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (format == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.format = format;
        this.value = value;
    }

    @Override
    public boolean isMetricValue() {
        return true;
    }

    @Override
    public boolean isMetricRequest() {
        return false;
    }

    @Override
    public boolean isMetricMetadata() {
        return false;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public boolean isNumeric() {
        switch (this.getRecordType()) {
            case STRING: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        return "" + this.value;
    }

    @Override
    public Number getNumericValue() {
        if (this.value instanceof Number) {
            return (Number)this.value;
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{recordType=" + (Object)((Object)this.getRecordType()) + ", hostName=" + this.getHostName() + ", metricName=" + this.getMetricName() + ", spoof=" + this.isSpoof() + ", format=" + this.format + ", value=" + this.value + " (valueClass=" + this.value.getClass().getSimpleName() + ")" + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        IGangliaMetricMessage t = (IGangliaMetricMessage)o;
        if (!this.getRecordType().equals((Object)t.getRecordType())) {
            return false;
        }
        if (!this.getHostName().equals(t.getHostName())) {
            return false;
        }
        if (!this.getMetricName().equals(t.getMetricName())) {
            return false;
        }
        if (this.isSpoof() != t.isSpoof()) {
            return false;
        }
        if (!this.getValue().equals(t.getValue())) {
            return false;
        }
        if (this.getValue().getClass() != t.getValue().getClass()) {
            return false;
        }
        return this.getFormat().equals(t.getFormat());
    }

    @Override
    public int hashCode() {
        return this.getMetricName().hashCode();
    }
}

