/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.util;

import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SysStreamHandler {
    private static final Logger LOGGER = LogManager.getLogger(SysStreamHandler.class);

    public static void redirectToLoggers() {
        System.setOut(SysStreamHandler.createLoggingProxy(System.out, Level.DEBUG));
        System.setErr(SysStreamHandler.createLoggingProxy(System.err, Level.ERROR));
    }

    private static PrintStream createLoggingProxy(PrintStream realPrintStream, final Level level) {
        return new PrintStream((OutputStream)realPrintStream){

            @Override
            public void print(String string) {
                LOGGER.log(level, string);
            }

            @Override
            public void println(String string) {
                LOGGER.log(level, string);
            }
        };
    }
}

